#ifndef PHOTOLISTWIDGET_H
#define PHOTOLISTWIDGET_H

#include <QtGui/QListWidget>
#include <QtCore/QStringList>

class QMenu;
class Photo;
class ServiceMgr;
class Friend;
class Album;

class PhotoListWidget : public QListWidget
{
    Q_OBJECT
public:
    explicit PhotoListWidget(ServiceMgr* mgr, QWidget *parent = 0);

protected:
    Qt::DropActions supportedDropActions();
    QStringList mimeTypes();
    QMimeData* mimeData(const QList<QListWidgetItem *> items) const;

    void mousePressEvent(QMouseEvent *event);

private:
    QMenu* createPhotoMenu(const Photo& photo);

    ServiceMgr* mServiceMgr;

private slots:
    void showPhotoMenu(const QPoint& pos);
    void onMenuAction(QObject* object);
    void onSelectAction();
};

#endif // PHOTOLISTWIDGET_H
