#include "qfriendlistmodel.h"

int QFriendListModel::rowCount(const QModelIndex &) const
 {
     return onlineList.isEmpty() ? 0 : onlineList.count();
 }

QVariant QFriendListModel::data(const QModelIndex &index, int role) const
 {
     if (!index.isValid())
         return QVariant();

     if (index.row() >= onlineList.size())
         return QVariant();

     if (role == Qt::DisplayRole)
         return onlineList.at(index.row()).name();

     if (role == Qt::DecorationRole)
         return onlineList.at(index.row()).icon();

     if (role == Qt::UserRole)
     {
         QVariant v;
         v.setValue(onlineList.at(index.row()));
         return v;
     }

     return QVariant();
 }

QVariant QFriendListModel::headerData(int section, Qt::Orientation orientation,
                                      int role) const
 {
     if (role != Qt::DisplayRole)
         return QVariant();

     if (orientation == Qt::Horizontal)
         return QString("Column %1").arg(section);

     return QString("Row %1").arg(section);
 }

void QFriendListModel::updateList(const FriendList &list)
{
    qDebug() << __FILE__ << ":" << __LINE__ << ": new size:" << list.length();
    this->frList = list;
    this->updateOnlineList();
}

void QFriendListModel::setNameFilter(const QString &str)
{
    this->nameFilter = str;
    this->updateOnlineList();
}

void QFriendListModel::updateOnlineList()
{
    FriendList newList;

    for(int i = 0; i < this->frList.length(); i++)
    {
        if (this->frList.at(i).name().indexOf(this->nameFilter, 0, Qt::CaseInsensitive) >= 0)
            newList.append(this->frList.at(i));
    }

    if (onlineList.size() == newList.size()) {
        onlineList = newList;
    } else if (onlineList.size() < newList.size()) {
        beginInsertRows(QModelIndex(), onlineList.size(), newList.size() - 1);
        onlineList = newList;
        endInsertRows();
    } else {
        beginRemoveRows(QModelIndex(), newList.size(), onlineList.size() - 1);
        onlineList = newList;
        endRemoveRows();
    }
    emit dataChanged(this->index(0), this->index(newList.size()));
}

QModelIndex QFriendListModel::getIndex(const Friend &fr) const
{
    return this->getIndex(fr.accountId(), fr.ownerId());
}

QModelIndex QFriendListModel::getIndex(const QString& accountId, const QString& ownerId) const
{
    for (int i = 0; i < this->frList.length(); i++)
    {
        if (accountId == this->frList.at(i).accountId() &&
                ownerId == this->frList.at(i).ownerId())
        {
            return this->index(i);
        }
    }

    return QModelIndex();
}
