#ifndef FILTERPANEL_H
#define FILTERPANEL_H

#include <QWidget>
#include <QVariant>
#include <QMetaType>

class QIcon;
class QToolBar;
class QString;
class QActionGroup;
class DriverInfo;

struct FilteredService
{
    QAction* action;
    DriverInfo* driverInfo;
    int index;
};
Q_DECLARE_METATYPE(FilteredService)

class FilterPanel : public QWidget
{
    Q_OBJECT

    QToolBar* mToolbar;
    QActionGroup* mActionGroup;

    int mLastIndex;
    int mCurrentIndex;

    void createToolbar();

public:
    explicit FilterPanel(QWidget *parent = 0);

    void addItem(QAction* action, DriverInfo* driver, bool checked = false);
    QList<QAction*> getServiceActions();
    DriverInfo* state() const;

signals:
    void itemSelected(DriverInfo* driverInfo, int index);

private slots:
    void serviceSelected(QAction* act);

public slots:
    void addItem(const QIcon& icon, DriverInfo* driver, bool checked = false);
    void addItem(const QString& string, DriverInfo* driver, bool checked = false);
    void clear();
    void checkItem(int index);
};

#endif // FILTERPANEL_H
