#include "feedview.h"

#include <QMouseEvent>
#include <QDebug>
#include <QMessageBox>
#include <QTimer>

#include "widgets/feed/feedmodel.h"
#include "widgets/feed/regionmap.h"
#include "datatypes/qattachment.h"
#include "datatypes/qeventfeed.h"

FeedView::FeedView(QWidget *parent) :
    QListView(parent)
{
}

void FeedView::mousePressEvent(QMouseEvent* event)
{
    // Get index that clicked
    QPoint pos = event->pos();
    QModelIndex index = indexAt(pos);

    // Get point relative to item topLeft corner
    QPoint relPos = pos - visualRect(index).topLeft();

    QVariant data = index.data(FeedModel::MapRole);
    if (data.canConvert<RegionMap>()) {
        RegionMap map = data.value<RegionMap>();
        QVariant value = map.value(relPos);

        if (value.canConvert<QEventFeed>())
            processFeed(value.value<QEventFeed>());
    }

    QListView::mousePressEvent(event);
}

void FeedView::scrollTo(const QModelIndex&, QAbstractItemView::ScrollHint)
{
    // Don't scroll
}

void FeedView::processFeed(const QEventFeed& feed)
{
    switch (feed.attach().type()) {
    case QAttachment::LinkAttach:
        emit linkClicked(feed.attach().objectUrl());
        break;

    case QAttachment::ImageAttach:
        emit imageClicked(feed.toPhoto());
        break;

    default:
        ;
    }
}
