#include "uinetworksettings.h"
#include "ui_uinetworksettings.h"

UINetworkSettings::UINetworkSettings(ServiceMgr *sm, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::UINetworkSettings)
{
    ui->setupUi(this);
    this->sm = sm;

    ServiceMgr::ProxyType proxy = (ServiceMgr::ProxyType)this->sm->settings->value(SETTINGS_PROXY).toInt();

    // set proxy settings
    switch (proxy) {
    case ServiceMgr::NoProxy:
        ui->noProxyButton->setChecked(true);
        break;
    case ServiceMgr::SystemProxy:
        ui->systemProxyButton->setChecked(true);
        break;
    case ServiceMgr::UserProxy:
        ui->manualProxyButton->setChecked(true);
        break;
    default:
        qWarning() << "unknown proxy type";
    }

    ui->proxyServerInput->setText(this->sm->settings->value(SETTINGS_PROXYHOST).toString());
    ui->proxyPortInput->setText(this->sm->settings->value(SETTINGS_PROXYPORT).toString());
}

UINetworkSettings::~UINetworkSettings()
{
    delete ui;
}

void UINetworkSettings::on_buttonBox_accepted() {
    // checkout proxy settings
    if (ui->noProxyButton->isChecked()) {
        this->sm->settings->setValue(SETTINGS_PROXY, ServiceMgr::NoProxy);
    } else {
        if (ui->systemProxyButton->isChecked()) {
            this->sm->settings->setValue(SETTINGS_PROXY, ServiceMgr::SystemProxy);
        } else {
            if (ui->manualProxyButton->isChecked()) {
                this->sm->settings->setValue(SETTINGS_PROXY, ServiceMgr::UserProxy);
                this->sm->settings->setValue(SETTINGS_PROXYHOST, ui->proxyServerInput->text());
                this->sm->settings->setValue(SETTINGS_PROXYPORT, ui->proxyPortInput->text().toInt());
            } else {
                qWarning() << "can't recognize type of proxy";
            }
        }
    }
    this->sm->updateDriverSettings();
}
