#ifndef QLISTFRIENDWIDGET_H
#define QLISTFRIENDWIDGET_H

#include <QWidget>
#include <QPushButton>
#include <QModelIndex>
#include <QAction>

#include <utils/hintedit.h>
#include <servicemgr.h>

#include "qfriendlistmodel.h"

namespace Ui {
    class QFriendListWidget;
}

class QToolBar;
class QFriendListWidget : public QWidget
{
    Q_OBJECT

public:
    explicit QFriendListWidget(QFont fnt, ServiceMgr *sm = 0, QWidget *parent = 0);
    ~QFriendListWidget();

    Friend getSelectedFriend() const;

    void selectFriend(const Friend &fr);
    QToolBar* filtersToolBar() const;

signals:
    void ownerSelected(Friend fr);

private slots:
    // occurs when user selects friend on list
    void itemSelected(QModelIndex index);

    void itemSelected(QAction *act);

    // seach field was updated
    void editOwnr_textChanged(QString str);

    // reset search field
    void buttonResetOwnr_clicked();

    void updateFriends(FriendList list, bool isLastUpdate);
private:
    Ui::QFriendListWidget *ui;

    HintEdit *editOwnr;
    QPushButton *buttonEditOwnr;
    ServiceMgr *sm;

    // used model to store list of friends
    QFriendListModel *model;

    // the index of selected item
    QModelIndex selectedItem;

    QString selectedFrAccount;

    QString selectedFrId;

    // true if me was selected, otherwise - false
    bool isMeSelected;

    QToolBar* filtersToolBar_;
};

#endif // QLISTFRIENDWIDGET_H
