#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "alarmHandler.h"
#include "PrayTime.h"
#include <QSettings>
#include <QInputDialog>
#include <iostream>
#include <QMessageBox>
using namespace std;

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    createMenu();

    ui->setupUi(this);
    setupTimes();

}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void MainWindow::showOptions(){

if (optionsDialog.isNull()) {
        optionsDialog = new OptionsDialog(this);
#if defined Q_WS_HILDON || defined Q_WS_MAEMO_5
       optionsDialog->setMinimumSize(size().width(),size().height()-100);
#else
        optionsDialog->showMaximized();
#endif
        optionsDialog->exec();
        delete optionsDialog;
        optionsDialog = 0;
        setupTimes();
    }
}

void showAlarmTimes(){

}

void MainWindow::showAbout(){
    qDebug("About");
}

void MainWindow::showAlarmTimes(){
    QMessageBox msgbox;
    msgbox.setText(AlarmHandler::QueryAppAlarms());
    msgbox.exec();
}
void MainWindow::testAzanAlarm(){
    AlarmHandler::testAzanAlarm();
}

void MainWindow::createMenu(){
    menuBar()->addAction("Options", this, SLOT(showOptions()));
    menuBar()->addAction("About", this, SLOT(showAbout()));
    menuBar()->addAction("Check Alarm Times", this, SLOT(showAlarmTimes()));
    menuBar()->addAction("Test Azan", this, SLOT(testAzanAlarm()));

}


void MainWindow::setupTimes(){
    double latitude, longitude, timeZone;
    if (this->settings.setupCompleted() == false){
       showOptions();
    }
    latitude = settings.getLatitude();
    longitude = settings.getLongitude();
    timeZone = settings.getTimeZone();

    QDateTime dateTime = QDateTime::currentDateTime();
    PrayTime praytime(settings.getCalcMethod(), settings.getJuristicMethod(), settings.getLatMethod(), settings.getTimeFormat());
    praytime.getPrayerTimes(dateTime, latitude, longitude, timeZone);
    QString * prayertimes = praytime.getPrayTimesArray();
    ui->fajrTime->setText(prayertimes[0]);
    ui->sunriseTime->setText(prayertimes[1]);
    ui->duhrTime->setText(prayertimes[2]);
    ui->asrTime->setText(prayertimes[3]);
    ui->maghribTime->setText(prayertimes[4]);
    ui->ishaaTime->setText(prayertimes[6]);

}

void MainWindow::printTimes(QString times){
    double latitude, longitude, timeZone;
    if (this->settings.setupCompleted() == false){
       show();
       showOptions();
    }
    QString labelsArray[] = {"Fajr:    ","Sunrise: ","Duhr:    ","Asr:     ","Maghrib: ","Sunset:  ","Ishaa:   "};
    if (!times.contains("l")){
        for (int i = 0; i < 7; i++){
            labelsArray[i].clear();
        }
    }

    latitude = settings.getLatitude();
    longitude = settings.getLongitude();
    timeZone = settings.getTimeZone();

    QDateTime dateTime = QDateTime::currentDateTime();
    PrayTime praytime(settings.getCalcMethod(), settings.getJuristicMethod(), settings.getLatMethod(), settings.getTimeFormat());
    praytime.getPrayerTimes(dateTime, latitude, longitude, timeZone);
    QString * prayertimes = praytime.getPrayTimesArray();

    if (times.contains("f")){
            cout << labelsArray[0].toLatin1().data() << prayertimes[0].toLatin1().data() << endl;
    }
    if (times.contains("s")){
            cout << labelsArray[1].toLatin1().data() << prayertimes[1].toLatin1().data() << endl;
    }
    if (times.contains("d")){
            cout << labelsArray[2].toLatin1().data() << prayertimes[2].toLatin1().data() << endl;
    }
    if (times.contains("a")){
            cout << labelsArray[3].toLatin1().data() << prayertimes[3].toLatin1().data() << endl;
    }
    if (times.contains("m")){
            cout << labelsArray[4].toLatin1().data() << prayertimes[4].toLatin1().data() << endl;
    }
    if (times.contains("i")){
            cout << labelsArray[6].toLatin1().data() << prayertimes[6].toLatin1().data() << endl;
    }
    exit(0);
}


