#ifndef DBUSCOMMANDS_H
#define DBUSCOMMANDS_H
#include <QtDBus>
#include <QString>
#ifdef Q_WS_MAEMO_5
#include <mce/mode-names.h>
#include <mce/dbus-names.h>
#endif

class DbusCommands: public QObject
{
    Q_OBJECT
public:
    DbusCommands(QObject* parent=0);
    void enableVibration();
    void vibrate();
    void unlockScreenAndKeys();
    void setProfile(QString profileString);
    void showNotification(QString notifyString);
    QString getCurrentProfile();
public slots:
    /**
      this method is a slot used by the application to set profile to silent
      after the window is closed
     */
    void setProfileSilent();
    void stopVibration();

private:
    QDBusInterface* getMCEDbusInterface();
    QDBusInterface*  getProfiledDbusInterface();
    QDBusInterface*  getNotificationDbusInterface();
    QObject* commandParent;

};

#endif // DBUSCOMMANDS_H
