#include "alarmHandler.h"
#include <QString>
#include <QDateTime>
#include "PrayTime.h"
#include <qmessagebox.h>

void AlarmHandler::setupAzan()
{
    AlarmHandler::deleteAllAzanAlarms();
    PrayerTimeSettings settings;
    QDateTime dateTime = QDateTime::currentDateTime();
    PrayTime prayTime(settings.getCalcMethod(), settings.getJuristicMethod(), settings.getLatMethod(), settings.getTimeFormat());
    prayTime.getPrayerTimes(dateTime, settings.getLatitude(), settings.getLongitude(), settings.getTimeZone());
    QDateTime time;
    time.setDate(QDate::currentDate());
    addDailyAzanAlarmScheduler();
    if(settings.getFagrEnabled()){
        time.setTime(QTime::fromString(prayTime.getPrayTimesArray()[0] ,"hh:mm"));
        addAzanAlarm(time.addSecs(settings.getFagrAMargin()*60).toTime_t(),1);
        if(settings.getFagrAMargin()!=settings.getFagrIMargin()){
            addAzanAlarm(time.addSecs(60*settings.getFagrIMargin()).toTime_t(),11);
        }
    }
    if(settings.getZuhrEnabled()){
        time.setTime(QTime::fromString(prayTime.getPrayTimesArray()[2] ,"hh:mm"));
        addAzanAlarm(time.addSecs(60*settings.getZuhrAMargin()).toTime_t(),2);
        if(settings.getZuhrAMargin()!=settings.getZuhrIMargin()){
            addAzanAlarm(time.addSecs(60*settings.getZuhrIMargin()).toTime_t(),22);
        }
    }
    if(settings.getAsrEnabled()){
        time.setTime(QTime::fromString(prayTime.getPrayTimesArray()[3] ,"hh:mm"));
        addAzanAlarm(time.addSecs(60*settings.getAsrAMargin()).toTime_t(),3);
        if(settings.getAsrAMargin()!=settings.getAsrIMargin()){
            addAzanAlarm(time.addSecs(60*settings.getAsrIMargin()).toTime_t(),33);
        }
    }
    if(settings.getMagribEnabled()){
        time.setTime(QTime::fromString(prayTime.getPrayTimesArray()[4] ,"hh:mm"));
        addAzanAlarm(time.addSecs(60*settings.getMagribAMargin()).toTime_t(),4);
        if(settings.getMagribAMargin()!=settings.getMagribIMargin()){
            addAzanAlarm(time.addSecs(60*settings.getMagribIMargin()).toTime_t(),44);
        }
    }
    if(settings.getIshaEnabled()){
        time.setTime(QTime::fromString(prayTime.getPrayTimesArray()[6] ,"hh:mm"));
        addAzanAlarm(time.addSecs(60*settings.getIshaAMargin()).toTime_t(),5);
        if(settings.getIshaAMargin()!=settings.getIshaIMargin()){
            addAzanAlarm(time.addSecs(60*settings.getIshaIMargin()).toTime_t(),55);
        }
    }
}
void AlarmHandler::testAzanAlarm(){
    addAzanAlarm(QDateTime::currentDateTime().addSecs(2).toTime_t(),11);
}

cookie_t AlarmHandler::addAzanAlarm(time_t azanTime,int azanNumber){
     cookie_t cookie = 0;
     alarm_event_t *eve = 0;
     alarm_action_t *act = 0;

     /* Create alarm event structure, set application
      * identifier and dialog message */
     eve = alarm_event_create();
     alarm_event_set_alarm_appid(eve, "mprayertime");
     char alarmMessage[100]="\0";
     strcat(alarmMessage,"/usr/bin/mprayertime 'Azan:");
     switch(azanNumber){
     case(1):
         strcat(alarmMessage,"fagr azan");
         break;
     case(11):
         strcat(alarmMessage,"fagr ikama");
         break;
     case(2):
         strcat(alarmMessage,"zuhr azan");
         break;
     case(22):
         strcat(alarmMessage,"zuhr ikama");
         break;
     case(3):
         strcat(alarmMessage,"asr azan");
         break;
     case(33):
         strcat(alarmMessage,"asr ikama");
         break;
     case(4):
         strcat(alarmMessage,"magrib azan");
         break;
     case(44):
         strcat(alarmMessage,"magrib ikama");
         break;
     case(5):
         strcat(alarmMessage,"isha azan");
         break;
     case(55):
         strcat(alarmMessage,"isha ikama");
         break;
    }
    strcat(alarmMessage,"'");
      //alarm_event_set_message(eve, alarmMessage);
     //alarm_event_set_sound(eve,"azan.wav");
     /* Use absolute time triggering, show dialog
      * ten seconds from now */
     eve->alarm_time =azanTime ;

     /* Add stop button action */
//     act = alarm_event_add_actions(eve, 1);
//     alarm_action_set_label(act, "Stop");
//     act->flags |= ALARM_ACTION_WHEN_RESPONDED;
//     act->flags |= ALARM_ACTION_TYPE_NOP;
     act = alarm_event_add_actions(eve, 1);
     act->flags = ALARM_ACTION_WHEN_TRIGGERED | ALARM_ACTION_TYPE_EXEC;
     alarm_action_set_exec_command(act,alarmMessage);

//     /* Add snooze button action */
//     act = alarm_event_add_actions(eve, 1);
//     alarm_action_set_label(act, "Snooze");
//     act->flags |= ALARM_ACTION_WHEN_RESPONDED;
//     act->flags |= ALARM_ACTION_TYPE_SNOOZE;

     /* Send the alarm to alarmd */
     cookie = alarmd_event_add(eve);

     /* Free all dynamic memory associated with the
      * alarm event */
     alarm_event_delete(eve);
     return cookie;


}

cookie_t AlarmHandler::addDailyAzanAlarmScheduler()
{
     alarm_event_t *newEvent = 0;
     alarm_action_t *act = 0;

     cookie_t resultCookie;

     /* Create a new alarm event object. */
     newEvent = alarm_event_create();

     /* Set the application ID. */
     alarm_event_set_alarm_appid(newEvent, "mprayertime");

     /* Set the title of the alarm. */
     alarm_event_set_title(newEvent, "Azan");
     newEvent->alarm_time = QDateTime(QDate::currentDate().addDays(1)).toTime_t()+1 ;
     //repeats every one day
     newEvent->recur_secs = 24 * 60 * 60;
     //indefinite
     newEvent->recur_count = -1;

     act = alarm_event_add_actions(newEvent, 1);
     act->flags = ALARM_ACTION_WHEN_TRIGGERED | ALARM_ACTION_TYPE_EXEC;


     /* Now all you have to do is tell the action which command you want to
      * "execute". */
     alarm_action_set_exec_command(act, "/usr/bin/mprayertime setupAlarm");

     /* Finally with everything setup, try to add your event to the alarm queue. */
     resultCookie = alarmd_event_add(newEvent);
     return 0;
}

cookie_t AlarmHandler::addProfileAlarm(QString whichAzan)
{
     alarm_event_t *newEvent = 0;
     alarm_action_t *act = 0;

     cookie_t resultCookie;

     /* Create a new alarm event object. */
     newEvent = alarm_event_create();

     /* Set the application ID. */
     alarm_event_set_alarm_appid(newEvent, "mprayertime");

     /* Set the title of the alarm. */
     alarm_event_set_title(newEvent, "Azan");
     int profileMargin;
     PrayerTimeSettings settings;
     //set the profile return to 10 minutes
     if(whichAzan.contains(QString("fagr"))){
         profileMargin=settings.getFagrSPeriod();
     }else if(whichAzan.contains(QString("zuhr"))){
         profileMargin=settings.getZuhrSPeriod();
     }else if(whichAzan.contains(QString("asr"))){
        profileMargin=settings.getAsrSPeriod();
     }else if(whichAzan.contains(QString("magrib"))){
        profileMargin=settings.getMagribSPeriod();
     }else if(whichAzan.contains(QString("isha"))){
        profileMargin=settings.getIshaSPeriod();
    }
     newEvent->alarm_time = time(0)+profileMargin*60;
     //indefinite
     newEvent->recur_count =0;

     act = alarm_event_add_actions(newEvent, 1);
     act->flags = ALARM_ACTION_WHEN_TRIGGERED | ALARM_ACTION_TYPE_EXEC;


     /* Now all you have to do is tell the action which command you want to
      * "execute". */
     alarm_action_set_exec_command(act, "/usr/bin/mprayertime restoreProfile");

     /* Finally with everything setup, try to add your event to the alarm queue. */
     resultCookie = alarmd_event_add(newEvent);
     return 0;
}

bool AlarmHandler::delete_alarm(cookie_t cookie)
{
  return ( alarmd_event_del(cookie) != -1 );
}

bool AlarmHandler::deleteAllAzanAlarms(){
    cookie_t *list = 0;
    cookie_t cookie = 0;
    alarm_event_t *eve = 0;
    bool returnValue=false;

    if( (list = alarmd_event_query(0,0, 0,0, "mprayertime")) == 0 )
    {
        returnValue=false;
        goto cleanup;
    }

    for( int i = 0; (cookie = list[i]) != 0; ++i )
    {
       delete_alarm(cookie);

    }
    returnValue=true;
    cleanup:
    free(list);
    alarm_event_delete(eve);
    return returnValue;
}


QString AlarmHandler::QueryAppAlarms()
{
    QString text="";
    cookie_t *list = 0;
    cookie_t cookie = 0;
    alarm_event_t *eve = 0;

    //if( (list = alarmd_event_query(0,0, 0,0, NULL)) == 0 )
    if( (list = alarmd_event_query(0,0, 0,0, "mprayertime")) == 0 )
    {
    text.append("query failed\n");
    goto cleanup;
    }

    for( int i = 0; (cookie = list[i]) != 0; ++i )
    {
        alarm_event_delete(eve);

        if( (eve = alarmd_event_get(cookie)) == 0 )
        {
             text.append("unable to get details for cookie=");
              continue;
         }
   //     text.append(eve->sound);
        text.append(QDateTime::fromTime_t(eve->alarm_time).toString("dd/MM/yyyy hh.mm "));

    }

    cleanup:
    free(list);
    alarm_event_delete(eve);
    return text;
}
