#ifndef OPTIONSDIALOG_H
#define OPTIONSDIALOG_H

#include <QDialog>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QButtonGroup>
#include <QLabel>
#include <QLineEdit>
#include <QRadioButton>
#include "prayertimesettings.h"
#include "QGeoPositionInfoSource"

QTM_USE_NAMESPACE

namespace Ui {
    class OptionsDialog;
}

class OptionsDialog : public QDialog {
    Q_OBJECT
public:
    explicit OptionsDialog(QWidget *parent = 0);
    ~OptionsDialog();

public slots:
    void saveClickedHandler();
    void autoConfigureClickHandler();
    void positionUpdated(const QGeoPositionInfo &info);

protected:
    void changeEvent(QEvent *e);

private:
    void save();
    QString doubleToString(double in);
    QString intToString(int in);


private:
    Ui::OptionsDialog *ui;
#ifdef Q_OS_SYMBIAN
    QVBoxLayout* layout;
#else
    QHBoxLayout* layout;
#endif

    PrayerTimeSettings settings;
    QGeoPositionInfoSource *source;


};

#endif // OPTIONSDIALOG_H
