#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "PrayTime.h"
#include <QSettings>
#include <QInputDialog>

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    createMenu();

    ui->setupUi(this);
    setupTimes();

}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void MainWindow::showOptions(){

if (optionsDialog.isNull()) {
        optionsDialog = new OptionsDialog(this);
#if defined Q_WS_HILDON || defined Q_WS_MAEMO_5
       optionsDialog->setMinimumSize(size().width(),size().height()-100);
#else
        optionsDialog->showMaximized();
#endif
        optionsDialog->exec();
        delete optionsDialog;
        optionsDialog = 0;
        setupTimes();
    }
}

void MainWindow::showAbout(){
    qDebug("About");
}

void MainWindow::createMenu(){
    menuBar()->addAction("Options", this, SLOT(showOptions()));
    menuBar()->addAction("About", this, SLOT(showAbout()));
}


void MainWindow::setupTimes(){
    double latitude, longitude, timeZone;
    if (this->settings.setupCompleted() == false){
       showOptions();
    }
    latitude = settings.getLatitude();
    longitude = settings.getLongitude();
    timeZone = settings.getTimeZone();
    QDateTime dt;
    QDateTime utc;
    dt = QDateTime::currentDateTime();
    utc = dt.toUTC();
    qDebug("local: %i, utc: %i, diff: %i",dt.time().hour(), utc.time().hour(),dt.time().hour() - utc.time().hour());



    QDateTime dateTime = QDateTime::currentDateTime();
    PrayTime praytime(settings.getCalcMethod(), settings.getJuristicMethod(), settings.getLatMethod(), settings.getTimeFormat());
    praytime.getPrayerTimes(dateTime, latitude, longitude, timeZone);
    QString * prayertimes = praytime.getPrayTimesArray();
    ui->fajrTime->setText(prayertimes[0]);
    ui->sunriseTime->setText(prayertimes[1]);
    ui->duhrTime->setText(prayertimes[2]);
    ui->asrTime->setText(prayertimes[3]);
    ui->maghribTime->setText(prayertimes[4]);
    ui->ishaaTime->setText(prayertimes[6]);

}
