// 
// ConditionalExpression.cs
//  
// Author:
//       Mike Krüger <mkrueger@novell.com>
// 
// Copyright (c) 2009 Novell, Inc (http://www.novell.com)
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

namespace MonoDevelop.CSharp.Ast
{
	/// <summary>
	/// Condition ? TrueExpression : FalseExpression
	/// </summary>
	public class ConditionalExpression : Expression
	{
		public readonly static Role<Expression> ConditionRole = Roles.Condition;
		public readonly static Role<CSharpTokenNode> QuestionMarkRole = new Role<CSharpTokenNode>("QuestionMark", CSharpTokenNode.Null);
		public readonly static Role<Expression> TrueRole = new Role<Expression>("True", Expression.Null);
		public readonly static Role<CSharpTokenNode> ColonRole = Roles.Colon;
		public readonly static Role<Expression> FalseRole = new Role<Expression>("False", Expression.Null);
		
		public Expression Condition {
			get { return GetChildByRole(ConditionRole); }
			set { SetChildByRole(ConditionRole, value); }
		}
		
		public CSharpTokenNode QuestionMarkToken {
			get { return GetChildByRole (QuestionMarkRole); }
		}
		
		public Expression TrueExpression {
			get { return GetChildByRole(TrueRole); }
			set { SetChildByRole(TrueRole, value); }
		}
		
		public CSharpTokenNode ColonToken {
			get { return GetChildByRole (ColonRole); }
		}
		
		public Expression FalseExpression {
			get { return GetChildByRole(FalseRole); }
			set { SetChildByRole(FalseRole, value); }
		}
		
		public override S AcceptVisitor<T, S> (IAstVisitor<T, S> visitor, T data)
		{
			return visitor.VisitConditionalExpression (this, data);
		}
	}
}
