/*
 * Decompiled with CFR 0.152.
 */
package org.miskiewicz.mmmrpc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import org.miskiewicz.mmmrpc.MyCanvas;

public class MMMRPCClient
extends MIDlet
implements CommandListener,
DiscoveryListener {
    private RecordStore rs;
    private int rsIdDevices;
    String rsDevices;
    private int currentState;
    public static final int STATE_INIT_OK = 1;
    public static final int STATE_INIT_ERROR = 2;
    public static final int STATE_SCANNING = 3;
    public static final int STATE_SCANNING_ERROR = 4;
    public static final int STATE_CONNECTING = 5;
    public static final int STATE_CONNECTING_ERROR = 6;
    public static final int STATE_INPUT_KEYBOARD = 7;
    public static final int STATE_INPUT_MOUSE = 8;
    public static final int STATE_INPUT_SPECIAL = 9;
    public static final int STATE_ABOUT = 10;
    public static final int STATE_INPUT_ERROR = 11;
    private Display display;
    private Form screenError;
    private Form screenStart;
    private Form screenAbout;
    private List screenListOfDevices;
    private TextBox screenInputKeyboard;
    private Form screenInputSpecial;
    private ChoiceGroup screenInputSpecialGroup;
    private TextField screenInputSpecialText;
    Vector specialKeysList;
    private MyCanvas screenInputMouse;
    private Command cmdExit;
    private Command cmdStartDiscovery;
    private Command cmdStopDiscovery;
    private Command cmdConnect;
    private Command cmdSend;
    private Command cmdMouse;
    private Command cmdKeyboard;
    private Command cmdSpecial;
    private Command cmdTryAgain;
    private Command cmdAbout;
    private Command cmdBack;
    private LocalDevice devLocal;
    private DiscoveryAgent discoverAgent;
    Vector devRemote;
    private String connectionString;
    StreamConnection connection = null;
    OutputStream outputStream = null;
    InputStream inputStream = null;

    public MMMRPCClient() {
        this.InitializeComponents();
    }

    protected void InitializeComponents() {
        this.display = Display.getDisplay((MIDlet)this);
        this.cmdExit = new Command("Exit", 7, 1);
        this.cmdStartDiscovery = new Command("Find devices", 1, 1);
        this.cmdStopDiscovery = new Command("Stop", 1, 1);
        this.cmdConnect = new Command("Connect", 1, 1);
        this.cmdSend = new Command("Send", 1, 1);
        this.cmdMouse = new Command("Switch to: mouse", 1, 1);
        this.cmdKeyboard = new Command("Switch to: keyboard", 1, 1);
        this.cmdSpecial = new Command("Switch to: special", 1, 1);
        this.cmdTryAgain = new Command("Retry", 1, 1);
        this.cmdAbout = new Command("About", 1, 1);
        this.cmdBack = new Command("Back", 1, 1);
        this.screenError = new Form("Error!");
        this.screenError.addCommand(this.cmdExit);
        this.screenError.addCommand(this.cmdTryAgain);
        this.screenError.setCommandListener((CommandListener)this);
        this.screenAbout = new Form("About");
        this.screenAbout.append((Item)new StringItem("Author:", "Bartosz Miskiewicz"));
        this.screenAbout.append((Item)new StringItem("Website:", "http://www.miskiewicz.org/mmmrpc"));
        this.screenAbout.addCommand(this.cmdBack);
        this.screenAbout.setCommandListener((CommandListener)this);
        this.screenListOfDevices = new List("Searching...", 3);
        this.screenListOfDevices.addCommand(this.cmdExit);
        this.screenListOfDevices.addCommand(this.cmdStopDiscovery);
        this.screenListOfDevices.setCommandListener((CommandListener)this);
        this.screenInputKeyboard = new TextBox("Keyboard", "", 512, 0);
        this.screenInputKeyboard.addCommand(this.cmdSend);
        this.screenInputKeyboard.addCommand(this.cmdMouse);
        this.screenInputKeyboard.addCommand(this.cmdSpecial);
        this.screenInputKeyboard.addCommand(this.cmdExit);
        this.screenInputKeyboard.setCommandListener((CommandListener)this);
        this.screenInputMouse = new MyCanvas();
        this.screenInputMouse.addCommand(this.cmdSend);
        this.screenInputMouse.addCommand(this.cmdKeyboard);
        this.screenInputMouse.addCommand(this.cmdSpecial);
        this.screenInputMouse.addCommand(this.cmdExit);
        this.screenInputMouse.setCommandListener(this);
        this.screenInputSpecial = new Form("Special");
        this.screenInputSpecialGroup = new ChoiceGroup("Select special keys:", 2);
        this.specialKeysList = new Vector();
        this.screenInputSpecialGroup.append("Crtl", null);
        this.specialKeysList.addElement(new String("Control_L"));
        this.screenInputSpecialGroup.append("Shift", null);
        this.specialKeysList.addElement(new String("Shift"));
        this.screenInputSpecialGroup.append("Enter", null);
        this.specialKeysList.addElement(new String("Return"));
        this.screenInputSpecialGroup.append("Backspace", null);
        this.specialKeysList.addElement(new String("BackSpace"));
        this.screenInputSpecialGroup.append("Left", null);
        this.specialKeysList.addElement(new String("Left"));
        this.screenInputSpecialGroup.append("Right", null);
        this.specialKeysList.addElement(new String("Right"));
        this.screenInputSpecialGroup.append("Up", null);
        this.specialKeysList.addElement(new String("Up"));
        this.screenInputSpecialGroup.append("Down", null);
        this.specialKeysList.addElement(new String("Down"));
        this.screenInputSpecialText = new TextField("Additional key(s):", "", 64, 0);
        this.screenInputSpecial.append((Item)this.screenInputSpecialGroup);
        this.screenInputSpecial.append((Item)this.screenInputSpecialText);
        this.screenInputSpecial.addCommand(this.cmdSend);
        this.screenInputSpecial.addCommand(this.cmdKeyboard);
        this.screenInputSpecial.addCommand(this.cmdMouse);
        this.screenInputSpecial.addCommand(this.cmdExit);
        this.screenInputSpecial.setCommandListener((CommandListener)this);
        this.screenStart = new Form("Welcome");
        this.screenStart.addCommand(this.cmdStartDiscovery);
        this.screenStart.addCommand(this.cmdAbout);
        this.screenStart.addCommand(this.cmdExit);
        this.screenStart.setCommandListener((CommandListener)this);
        if (this.initLocalDevice() == 0) {
            this.screenStart.append((Item)new StringItem("Your device name is:", this.devLocal.getFriendlyName()));
            this.screenStart.append((Item)new StringItem("Your MAC address is:", this.devLocal.getBluetoothAddress()));
            this.screenStart.append((Item)new StringItem(" ", "Please press \"Find devices\" to start searching."));
            this.currentState = 1;
        } else {
            this.screenError.deleteAll();
            this.screenError.append((Item)new StringItem("Error:", "Error getting local device"));
            this.screenError.append((Item)new StringItem("Solution:", "Make sure your bluetooth interface is turned on"));
            this.currentState = 2;
        }
    }

    public void startApp() {
        switch (this.currentState) {
            case 10: {
                this.display.setCurrent((Displayable)this.screenAbout);
                break;
            }
            case 1: {
                this.display.setCurrent((Displayable)this.screenStart);
                break;
            }
            case 3: 
            case 5: {
                this.display.setCurrent((Displayable)this.screenListOfDevices);
                break;
            }
            case 9: {
                this.display.setCurrent((Displayable)this.screenInputSpecial);
                break;
            }
            case 7: {
                this.display.setCurrent((Displayable)this.screenInputKeyboard);
                break;
            }
            case 8: {
                this.display.setCurrent((Displayable)this.screenInputKeyboard);
                break;
            }
            default: {
                this.display.setCurrent((Displayable)this.screenError);
            }
        }
    }

    public void pauseApp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyApp(boolean unconditional) {
        if (this.currentState == 3) {
            this.stopDiscover();
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.flush();
                this.outputStream.close();
            }
            catch (IOException ex) {
            }
            finally {
                this.outputStream = null;
            }
        }
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException ex) {
            }
            finally {
                this.inputStream = null;
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.connection = null;
            }
        }
        this.notifyDestroyed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cmdExit) {
            this.destroyApp(true);
        } else if (command == this.cmdAbout) {
            this.currentState = 10;
            this.startApp();
        } else if (command == this.cmdBack) {
            this.currentState = 1;
            this.startApp();
        } else if (command == this.cmdTryAgain) {
            switch (this.currentState) {
                case 2: {
                    this.currentState = 1;
                    break;
                }
                case 4: {
                    this.currentState = 3;
                    break;
                }
                case 6: {
                    this.currentState = 5;
                    break;
                }
                case 11: {
                    this.currentState = 7;
                    break;
                }
            }
            this.startApp();
        } else if (command == this.cmdStartDiscovery) {
            int err = 0;
            err = this.startDeviceSearch();
            if (err != 0) {
                this.screenError.deleteAll();
                this.screenError.append((Item)new StringItem("Error:", "Cannot start device search"));
                this.screenError.append((Item)new StringItem("Solution:", "Make sure your bluetooth interface is turned on"));
                this.currentState = 4;
                this.startApp();
                return;
            }
            this.screenListOfDevices.removeCommand(this.cmdStartDiscovery);
            this.screenListOfDevices.removeCommand(this.cmdConnect);
            this.screenListOfDevices.removeCommand(this.cmdStopDiscovery);
            this.screenListOfDevices.addCommand(this.cmdStopDiscovery);
            this.currentState = 3;
            this.startApp();
        } else if (command == this.cmdStopDiscovery) {
            this.stopDiscover();
            this.discoveryStopped();
        } else if (command == this.cmdConnect) {
            int index = this.screenListOfDevices.getSelectedIndex();
            boolean err = false;
            this.screenError.append((Item)new StringItem("How many:", new Integer(index).toString()));
            if (index >= 0) {
                RemoteDevice rd = (RemoteDevice)this.devRemote.elementAt(index);
                this.connectionString = "btspp://" + rd.getBluetoothAddress() + ":3;authenticate=true;encrypt=true;master=false";
                try {
                    this.connection = (StreamConnection)Connector.open((String)this.connectionString);
                    this.currentState = 5;
                    this.outputStream = this.connection.openOutputStream();
                    this.currentState = 7;
                }
                catch (IOException e) {
                    this.connection = null;
                    this.screenError.deleteAll();
                    this.screenError.append((Item)new StringItem("Error:", e.getMessage()));
                    this.screenError.append((Item)new StringItem("Solution:", "Make sure your bluetooth interface is turned on on both devices"));
                    this.currentState = 6;
                }
                finally {
                    this.startApp();
                }
            } else {
                err = true;
            }
            if (err) {
                this.screenError.deleteAll();
                this.screenError.append((Item)new StringItem("Error:", "Cannot start service search"));
                this.screenError.append((Item)new StringItem("Solution:", "Make sure your bluetooth interface is turned on on both devices"));
                this.currentState = 6;
                this.startApp();
            }
        } else {
            if (command == this.cmdSend) {
                String commandToSend = new String();
                switch (this.currentState) {
                    case 7: {
                        commandToSend = "K" + this.screenInputKeyboard.getString();
                        this.screenInputKeyboard.setString("");
                        break;
                    }
                    case 8: {
                        break;
                    }
                    case 9: {
                        int i;
                        commandToSend = "S" + this.screenInputKeyboard.getString();
                        for (i = 0; i < this.screenInputSpecialGroup.size(); ++i) {
                            if (!this.screenInputSpecialGroup.isSelected(i)) continue;
                            if (commandToSend.length() > 1) {
                                commandToSend = commandToSend + "+";
                            }
                            commandToSend = commandToSend + (String)this.specialKeysList.elementAt(i);
                        }
                        String tmp = this.screenInputSpecialText.getString();
                        if (tmp.length() > 0) {
                            if (commandToSend.length() > 1) {
                                commandToSend = commandToSend + "+";
                            }
                            commandToSend = commandToSend + tmp;
                        }
                        this.screenInputKeyboard.setString("");
                        for (i = 0; i < this.screenInputSpecialGroup.size(); ++i) {
                            this.screenInputSpecialGroup.setSelectedIndex(i, false);
                        }
                        this.screenInputSpecialText.setString("");
                        break;
                    }
                }
                try {
                    try {
                        this.outputStream.write(commandToSend.getBytes("UTF-8"));
                        this.outputStream.flush();
                        return;
                    }
                    catch (Exception e) {
                        this.screenError.deleteAll();
                        this.screenError.append((Item)new StringItem("Error:", "Cannot send data"));
                        this.screenError.append((Item)new StringItem("Solution:", "Make sure your bluetooth interface is turned on on both devices and connection was not lost. Otherwise, restart this app."));
                        this.currentState = 11;
                        this.startApp();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    return;
                }
            }
            if (command == this.cmdKeyboard) {
                this.currentState = 7;
                this.startApp();
            } else if (command == this.cmdSpecial) {
                this.currentState = 9;
                this.startApp();
            } else if (command == this.cmdMouse) {
                this.screenError.deleteAll();
                this.screenError.append((Item)new StringItem("Error:", "Sorry, not implemented yet"));
                this.screenError.append((Item)new StringItem("Solution:", "Click retry to return into keyboard input."));
                this.currentState = 11;
                this.startApp();
            }
        }
    }

    protected int initLocalDevice() {
        try {
            this.devLocal = LocalDevice.getLocalDevice();
        }
        catch (BluetoothStateException e) {
            return -1;
        }
        return 0;
    }

    protected int startDeviceSearch() {
        this.discoverAgent = this.devLocal.getDiscoveryAgent();
        try {
            if (this.devRemote != null) {
                this.devRemote.removeAllElements();
            } else {
                this.devRemote = new Vector();
            }
            this.screenListOfDevices.deleteAll();
            this.discoverAgent.startInquiry(10390323, (DiscoveryListener)this);
        }
        catch (BluetoothStateException e) {
            return -1;
        }
        return 0;
    }

    public void deviceDiscovered(RemoteDevice remoteDev, DeviceClass devClass) {
        try {
            this.screenListOfDevices.append(remoteDev.getFriendlyName(false) + "(" + remoteDev.getBluetoothAddress() + ")", null);
            this.devRemote.addElement(remoteDev);
        }
        catch (IOException e) {
            return;
        }
    }

    public void servicesDiscovered(int transID, ServiceRecord[] servRecord) {
    }

    public void serviceSearchCompleted(int transID, int respCode) {
    }

    public void inquiryCompleted(int discType) {
        this.discoveryStopped();
    }

    protected void stopDiscover() {
        this.discoverAgent.cancelInquiry((DiscoveryListener)this);
    }

    protected void discoveryStopped() {
        this.screenListOfDevices.removeCommand(this.cmdStopDiscovery);
        this.screenListOfDevices.removeCommand(this.cmdConnect);
        this.screenListOfDevices.addCommand(this.cmdStartDiscovery);
        if (this.devRemote.size() > 0) {
            this.screenListOfDevices.addCommand(this.cmdConnect);
        }
        this.currentState = 5;
        this.startApp();
    }
}

