
#include "config.h"

#include <microfeed-common/microfeedconfiguration.h>
#include <microfeed-common/microfeedprotocol.h>
#include <microfeed-common/microfeedmisc.h>
#include <string.h>
#include <stdlib.h>

#include "configuration.h"

typedef struct {
	GtkWidget* dialog;
	GtkWidget* ok_button;
	GtkWidget* entry;
} ValueDialog;

static void item_modified(MicrofeedSubscriber* subscriber, const char* publisher, const char* uri, const char* uid, const char* error_name, const char* error_message, void* user_data) {
	GtkWidget* dialog;

	if (error_name) {
		dialog = gtk_message_dialog_new(*((GtkWindow**)user_data), GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "Could not modify value: %s", (error_message ? error_message : error_name));
		gtk_window_set_title(GTK_WINDOW(dialog), "Error");
		gtk_dialog_run(GTK_DIALOG(dialog));
		gtk_widget_destroy(dialog);
		if (*((GtkDialog**)user_data)) {
			gtk_dialog_response(*((GtkDialog**)user_data), GTK_RESPONSE_REJECT);
		}
	} else {
		if (*((GtkDialog**)user_data)) {
			gtk_dialog_response(*((GtkDialog**)user_data), GTK_RESPONSE_ACCEPT);
		}
	}
}

static int change_value(MicrofeedSubscriber* subscriber, GtkWindow* parent, const char* publisher, const char* uid, const char* type, const char* value) {
	int retvalue = 0;
	long int numeric_value;
	int has_numeric_value;
	char* s;
	MicrofeedItem* item;
	GtkWidget* dialog = NULL;
	
	numeric_value = strtol(value, &s, 10);
	if (*value && !*s) {
		has_numeric_value = 1;
	} else {
		has_numeric_value = 0;
	}
	
	if (!strcmp(type, "integer")) {
		if (has_numeric_value) {
			retvalue = 1;
		}
	} else if (!strcmp(type, "non-negative integer")) {
		if (has_numeric_value && numeric_value >= 0L) {
			retvalue = 1;
		}
	} else if (!strcmp(type, "positive integer")) {
		if (has_numeric_value && numeric_value > 0L) {
			retvalue = 1;
		}
	} else { /* also "password" and "string" */
		retvalue = 1;
	}
	
	if (retvalue) {
		item = microfeed_item_new(uid, time(NULL));
		microfeed_item_set_property(item, "setting.value", value);
		if (microfeed_subscriber_modify_item(subscriber, publisher, MICROFEED_FEED_URI_SETTINGS, item, item_modified, &dialog)) {
			dialog = gtk_message_dialog_new(GTK_WINDOW(parent), GTK_DIALOG_MODAL, GTK_MESSAGE_INFO, GTK_BUTTONS_CANCEL, "Modifying value... Wait!");
			gtk_window_set_title(GTK_WINDOW(dialog), "Wait");
			gtk_dialog_run(GTK_DIALOG(dialog));
			gtk_widget_destroy(dialog);
			dialog = NULL;
		}
	}
		
	return retvalue;	
}

static void on_entry_changed(GtkEditable* editable, gpointer user_data) {
	ValueDialog* value_dialog;
	
	value_dialog = (ValueDialog*)user_data;
	gtk_widget_set_sensitive(value_dialog->ok_button, TRUE);
}

void show_value_dialog(MicrofeedSubscriber* subscriber, GtkWindow* parent, const char* publisher, const char* uid, const char* text, const char* value, const char* unit, const char* type, int length) {
	ValueDialog* value_dialog;
	GtkWidget* widget;
	GtkWidget* table;
	const char* new_value;
	GtkWidget* dialog;
	
	value_dialog = microfeed_memory_allocate(ValueDialog);
	value_dialog->dialog = gtk_dialog_new_with_buttons("Change value", parent, 0, NULL);
	value_dialog->ok_button = gtk_button_new_from_stock(GTK_STOCK_OK);
	gtk_widget_set_sensitive(value_dialog->ok_button, FALSE);
	gtk_dialog_add_action_widget(GTK_DIALOG(value_dialog->dialog), value_dialog->ok_button, GTK_RESPONSE_ACCEPT);
#ifndef MAEMO_CHANGES
	widget = gtk_button_new_from_stock(GTK_STOCK_CANCEL);
	gtk_dialog_add_action_widget(GTK_DIALOG(value_dialog->dialog), widget, GTK_RESPONSE_NONE);
#endif

	table = gtk_table_new(3, 2, FALSE);
 	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(value_dialog->dialog)->vbox), table);
	widget = gtk_label_new(text);
	gtk_table_attach(GTK_TABLE(table), widget, 0, 2, 0, 1, GTK_FILL, 0, 3, 3);
	value_dialog->entry = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(value_dialog->entry), value);
	gtk_entry_set_max_length(GTK_ENTRY(value_dialog->entry), length);
	if (length < 16) {
		gtk_entry_set_width_chars(GTK_ENTRY(value_dialog->entry), length);
	}
	if (!strcmp(type, "password")) {
		gtk_entry_set_visibility(GTK_ENTRY(value_dialog->entry), FALSE);
	}
	g_signal_connect(value_dialog->entry, "changed", G_CALLBACK(on_entry_changed), value_dialog);
	gtk_table_attach(GTK_TABLE(table), value_dialog->entry, 0, 1, 1, 2, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 3, 3);
	widget = gtk_label_new(unit);
	gtk_misc_set_alignment(GTK_MISC(widget), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), widget, 1, 2, 1, 2, GTK_FILL, 0, 3, 3);

	gtk_widget_show_all(value_dialog->dialog);
	
	while (gtk_dialog_run(GTK_DIALOG(value_dialog->dialog)) == GTK_RESPONSE_ACCEPT) {
		new_value = gtk_entry_get_text(GTK_ENTRY(value_dialog->entry));
		if (change_value(subscriber, GTK_WINDOW(value_dialog->dialog), publisher, uid, type, new_value)) {
			break;
		} else {
			dialog = gtk_message_dialog_new(GTK_WINDOW(value_dialog->dialog), GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "Invalid value for %s.", type);
			gtk_window_set_title(GTK_WINDOW(dialog), "Error");
			gtk_dialog_run(GTK_DIALOG(dialog));
			gtk_widget_destroy(dialog);
		}
	}
	gtk_widget_destroy(value_dialog->dialog);	
}
