#include <dbus/dbus.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <gtk/gtk.h>
#include <microfeed-common/microfeedconfiguration.h>
#include <microfeed-subscriber/microfeedsubscriber.h>

#include "configuration.h"

int main(int argc, char** argv) {
	const char* identifier = NULL;
	MicrofeedSubscriber* subscriber;
	DBusError error;
	DBusConnection* connection;

	if (argc < 1 || argc > 2) {
		fprintf(stderr, "Usage: %s [subscriber]\n", (argc > 0 ? argv[0] : "microfeed-configuration"));

		return 1;
	} else if (argc == 2) {
		identifier = argv[1];
	}

	gtk_init(&argc, &argv);
	dbus_error_init(&error);
	connection = dbus_bus_get(DBUS_BUS_SESSION, &error);
	dbus_connection_setup_with_g_main(connection, NULL);
	
	subscriber = microfeed_subscriber_new("org.microfeed.Utils.Configuration", "/org/microfeed/Utils/Configuration", connection);

	show_publishers_dialog(subscriber, NULL, identifier);
	
	microfeed_subscriber_free(subscriber);
	
	return 0;
}
