
#include "config.h"

#include <gtk/gtk.h>
#include <microfeed-common/microfeedconfiguration.h>
#include <microfeed-subscriber/microfeedsubscriber.h>
#include <microfeed-common/microfeedmisc.h>
#include <string.h>

#include "configuration.h"

typedef struct {
	GtkWidget* dialog;
} NewDialog;

static void publisher_created(MicrofeedSubscriber* subscriber, const char* publisher, const char* uri, const char* uid, const char* error_name, const char* error_message, void* user_data) {
	GtkWidget* dialog;

	if (error_name) {
		dialog = gtk_message_dialog_new(*((GtkWindow**)user_data), GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "Could not create %s: %s", publisher, (error_message ? error_message : error_name));
		gtk_window_set_title(GTK_WINDOW(dialog), "Error");
		gtk_dialog_run(GTK_DIALOG(dialog));
		gtk_widget_destroy(dialog);
		if (*((GtkDialog**)user_data)) {
			gtk_dialog_response(*((GtkDialog**)user_data), GTK_RESPONSE_REJECT);
		}
	} else {
		if (*((GtkDialog**)user_data)) {
			gtk_dialog_response(*((GtkDialog**)user_data), GTK_RESPONSE_ACCEPT);
		}
	}
}

static gboolean create_new_publisher(MicrofeedSubscriber* subscriber, NewDialog* new_dialog, const char* publisher) {
	gboolean success = FALSE;
	GtkWidget* dialog = NULL;

	if (microfeed_subscriber_create_publisher(subscriber, publisher, publisher_created, &dialog)) {
		dialog = gtk_message_dialog_new(GTK_WINDOW(new_dialog->dialog), GTK_DIALOG_MODAL, GTK_MESSAGE_INFO, GTK_BUTTONS_CANCEL, "Creating publisher... Wait!");
		gtk_window_set_title(GTK_WINDOW(dialog), "Wait");
		if (gtk_dialog_run(GTK_DIALOG(dialog)) == GTK_RESPONSE_ACCEPT) {
			success = TRUE;
		}
		gtk_widget_destroy(dialog);
		dialog = NULL;
	}

	return success;
}

char* show_new_dialog(MicrofeedSubscriber* subscriber, GtkWindow* parent) {
	char* new_publisher = NULL;
	MicrofeedConfiguration* configuration;
	const char** providers;
	const char** providers_list;
	NewDialog* new_dialog;
	GtkWidget* table;
	GtkWidget* label;
	GtkWidget* entry;
#ifdef MAEMO_CHANGES
	GtkWidget* touch_selector;
	GtkWidget* picker_button;
#else
	GtkWidget* combo_box;
#endif
	char* text;
	const char* publisher;
	const char* provider;
	int index;

	configuration = microfeed_subscriber_get_configuration(subscriber);
	new_dialog = microfeed_memory_allocate(NewDialog);
	new_dialog->dialog = gtk_dialog_new_with_buttons("New Microfeed Publisher", NULL, 0, GTK_STOCK_CANCEL, GTK_RESPONSE_REJECT, GTK_STOCK_OK, GTK_RESPONSE_ACCEPT, NULL);
	table = gtk_table_new(2, 2, FALSE);
 	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(new_dialog->dialog)->vbox), table);
	label = gtk_label_new("Name:");
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), label, 0, 1, 0, 1, GTK_FILL, 0, 3, 3);
	entry = gtk_entry_new();
	gtk_table_attach(GTK_TABLE(table), entry, 1, 2, 0, 1, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 3, 3);
	label = gtk_label_new("Provider:");
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), label, 0, 1, 1, 2, GTK_FILL, 0, 3, 3);
#ifdef MAEMO_CHANGES
	touch_selector = hildon_touch_selector_new_text();
	for (providers = providers_list = microfeed_configuration_get_providers(configuration); providers && *providers; providers++) {
		text = g_strdup_printf("%s (%s)", microfeed_configuration_get_provider_name(configuration, *providers), *providers);
		hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(touch_selector), text);
		g_free(text);
	}
	hildon_touch_selector_set_active(HILDON_TOUCH_SELECTOR(touch_selector), 0, 0);
	picker_button = hildon_picker_button_new(HILDON_SIZE_AUTO, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
	hildon_picker_button_set_selector(HILDON_PICKER_BUTTON(picker_button), HILDON_TOUCH_SELECTOR(touch_selector));
	gtk_table_attach(GTK_TABLE(table), picker_button, 1, 2, 1, 2, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 3, 3);
#else
	combo_box = gtk_combo_box_new_text();
	for (providers = providers_list = microfeed_configuration_get_providers(configuration); providers && *providers; providers++) {
		text = g_strdup_printf("%s (%s)", microfeed_configuration_get_provider_name(configuration, *providers), *providers);
		gtk_combo_box_append_text(GTK_COMBO_BOX(combo_box), text);
		g_free(text);
	}
	gtk_combo_box_set_active(GTK_COMBO_BOX(combo_box), 0);
	gtk_table_attach(GTK_TABLE(table), combo_box, 1, 2, 1, 2, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 3, 3);
#endif

	gtk_widget_show_all(new_dialog->dialog);
	if (gtk_dialog_run(GTK_DIALOG(new_dialog->dialog)) == GTK_RESPONSE_ACCEPT) {
		publisher = gtk_entry_get_text(GTK_ENTRY(entry));
#ifdef MAEMO_CHANGES
		if ((index = hildon_touch_selector_get_active(HILDON_TOUCH_SELECTOR(touch_selector), 0)) != -1) {
#else
		if ((index = gtk_combo_box_get_active(GTK_COMBO_BOX(combo_box))) != -1) {
#endif
			provider = providers_list[index];
			text = g_strconcat(publisher, ":", provider, NULL);
			if (create_new_publisher(subscriber, new_dialog, text)) {
				new_publisher = text;
			} else {
				g_free(text);
			}
		}
	}
	gtk_widget_destroy(new_dialog->dialog);

	return new_publisher;
}
