#!/usr/bin/python
# -*- coding: koi8-r -*-
import gtk
import gobject
import hildon 
from ctypes import *

class SimpleMessageBox:
        """ just as name says - an simple message box """

        def __init__(self, name, wmclass, title, text, buttonlabel, parentwin):
            self._w = hildon.StackableWindow()
            if parentwin:
                    self._w.set_transient_for(parentwin)
                    self._w.set_position(gtk.WIN_POS_CENTER_ON_PARENT)
            self._w.set_title(title)
            self._w.set_wmclass(name + wmclass, name)
            self._w.set_resizable(False)
            self._w.connect('key_press_event', self._keyhandler)
            self._w.connect('destroy', self._destroy_cb)

            vbox = gtk.VBox(False, 5)
            vbox.set_border_width(10)
            self._w.add(vbox)

            hbox = gtk.HBox(False, 0)
            hbox.set_border_width(10)
            vbox.pack_start(hbox, 1, 1, 0)

            label = gtk.Label('\n' + text + '\n')
            hbox.pack_start(label, 1, 1, 0)

            self._alive = 1
            self._w.show_all()

        def _keyhandler(self, widget, event):
	        if event.keyval == gtk.keysyms.Escape:
                        self.close()

        def _close(self, widget):
                self.close()

        def _destroy_cb(self, widget):
                self._alive = 0

        def shown(self):
                return self._alive

        def focus(self):
                self._w.present()

        def close(self):
                self._w.destroy()

class SWin:
        def __init__(self, da):
                self.da = da
                self.middle_pressed = False
                self.middle_button = None
                self.middle_x = 0
                self.middle_y = 0
                self.button_press_treshold = 5
                self.move_started = False

#                self.swin = gtk.ScrolledWindow()
                self.swin = hildon.PannableArea()
                self.swin.mode = hildon.PANNABLE_AREA_MODE_ACCEL
                self.swin.set_events(gtk.gdk.BUTTON_PRESS_MASK | gtk.gdk.BUTTON_RELEASE_MASK | gtk.gdk.POINTER_MOTION_MASK)
                self.swin.connect("button_press_event", self.bp)
                self.swin.connect("button_release_event", self.bp)
                self.swin.connect("motion_notify_event", self.bp)
                if da:
                        if type(da) == gtk.DrawingArea:
                                self.swin.add_with_viewport(self.da)
                        else:
                                self.swin.add(self.da)

        def bp(self, widget, event):
                if event.type == gtk.gdk.BUTTON_PRESS: #and event.button == 2:
                        self.middle_pressed = True
                        self.move_started = False
                        self.middle_button = event.button
                        self.middle_x = event.x_root
                        self.middle_y = event.y_root
                elif event.type == gtk.gdk.BUTTON_RELEASE and event.button == self.middle_button:
                        self.middle_pressed = False
                elif event.type == gtk.gdk.MOTION_NOTIFY and self.middle_pressed:
                        #flags = gtk.gdk.device_get_core_pointer().get_state(self.swin.get_root_window())[1]
                        #if (self.middle_button == 3 and not (flags & gtk.gdk.BUTTON3_MASK)) or \
                        #   (self.middle_button == 2 and not (flags & gtk.gdk.BUTTON2_MASK)) or \
                        #   (self.middle_button == 1 and not (flags & gtk.gdk.BUTTON1_MASK)):
                        #        self.middle_pressed = False
                        #        return

                        if not self.move_started and \
                           abs(self.middle_x - event.x_root) < self.button_press_treshold and \
                           abs(self.middle_y - event.y_root) < self.button_press_treshold:
                                return

                        self.move_started = True

                        def adjust(adj, d):
                                if d != 0:
                                        av = adj.value + d
                                        if av < adj.lower: #round it
                                                av = adj.lower
                                        elif av > adj.upper - adj.page_size:
                                                av = adj.upper - adj.page_size
                                        adj.value = av

                        adjust(widget.get_hadjustment(), self.middle_x - event.x_root)
                        adjust(widget.get_vadjustment(), self.middle_y - event.y_root)
                        self.middle_x = event.x_root
                        self.middle_y = event.y_root

class Interface:
        def __init__(self, progname, stations, \
                     path_cb=None, station_cb=None, city_cb=None, dtime_cb=None, \
                     delta_cb=None, zoom_cb=None, show_info_cb=None, \
                     xsize=1024, ysize=800, delta=5, \
                     citylist=None, citynow=0, compact=False,
                     zoomlist=None, zoomnow=0, one_button=True, one_button_cb=None, station_numbers_map=None, win=None, is_fullscreen=False, thbox=None):
                maximize = False
                if not xsize:
                        xsize = 800
                        maximize = True
                if not ysize:
                        ysize = 480
                        maximize = True
				
                self.path_cb = path_cb
                self.station_cb = station_cb
                self.city_cb = city_cb
                self.dtime_cb = dtime_cb
                self.delta_cb = delta_cb
                self.zoom_cb = zoom_cb
                self.show_info_cb = show_info_cb
                self.stations = stations
                self.station_numbers_map = dict()
                self.station_numbers_map.clear()
                if stations != None:
                    i = 0
                    for st in self.stations:
                        ret = self.station_numbers_map.setdefault(st[1], i)
                        if ret == i:
                            i = i + 1
                        
                self.dont_set_path = False
                self.dont_set_from = False
                self.dont_set_to = False
                self.citylist = citylist
                self.dont_set_city = False
                self.da = None
                self.Swin = None
                self.label_found_text = [_("Found paths"), ""]
                self.label_time_text = [_("Time of a day:"), ""]
                self.label_city_text = [_("Map:"), ""]
                
                self.menu_items = [(_("Info"), "info", False),
                                   (_("Toggle compact mode"), "compact", True)]
                
                self.compact_mode = not compact #hack =)
                self.one_button = True
                self.one_button_cb = one_button_cb

                self.is_fullscreen = False
                
                self.zoomlist = zoomlist
                self.zoomnow = zoomnow
                
                self.middle_pressed = False
                self.middle_button = None
                self.middle_x = 0
                self.middle_y = 0
                self.button_press_treshold = 5
                self.move_started = False
                
                self.help_win = None
                self.helptext = _("MetroMap 0.1.3b for Maemo 5\n\n"
                                  "Maemo 5 version (c) Nikita Nalyutin\nhttps://garage.maemo.org/projects/metromap/\n\n"
                                  "PC version (c) Sergey Pinaev http://metromap.antex.ru\n\n"
                                  "Maps from pMetro (c) Boris Muradov\nExtra maps can be downloaded from http://pmetro.su/Maps.html \nand stored to /opt/metromap/data\n"
                                 )
                self.progname = progname
                
                self.win = hildon.StackableWindow()
                
                self.app = hildon.Program() 
                self.app.add_window(self.win) 
                ##self.win.set_menu(self.menu)
                self.menu = hildon.AppMenu()
                self.win.set_app_menu(self.menu)
                
                self.win.set_title(progname)
                self.win.set_wmclass(progname + 'Main', progname)
                self.win.set_resizable(True)
                self.win.set_border_width(0)
                self.xsize = xsize
                self.ysize = ysize
                self.win.set_default_size(self.xsize, self.ysize)
                self.win.connect('configure_event', self.__configure_win_cb)

                self.tips = gtk.Tooltips()
                
                vbox = gtk.VBox(False, 5)
                self.win.add(vbox)
                
                self.cb_from = self.create_ebox(self.stations)
                self.cb_from.set_title("From")
                self.cb_from.get_selector().connect("changed", self.from_selected)
                self.menu.append(self.cb_from)
                self.cb_from.show()
                
                self.cb_to = self.create_ebox(self.stations)
                self.cb_to.set_title("To")
                self.cb_to.get_selector().connect("changed", self.to_selected)
                self.menu.append(self.cb_to)
                self.cb_to.show()
                
                frame = gtk.Frame()
                vbox.pack_start(frame, False)
                tvbox = gtk.VBox(False, 5)
                tvbox.set_border_width(5)
                frame.add(tvbox)
                
                self.thbox = gtk.HBox(False, 5)
                tvbox.pack_start(self.thbox, False)
                				
                self.cb_path = hildon.PickerButton(gtk.HILDON_SIZE_AUTO,
                             hildon.BUTTON_ARRANGEMENT_HORIZONTAL)
                self.cb_path.set_title("")
                self.cb_path_selector = hildon.TouchSelector(text=True)
                self.cb_path.set_selector(self.cb_path_selector)
                self.cb_path_selector.connect("changed", self.path_selected)
                self.thbox.pack_start(self.cb_path, True)
                
                #self.cb_path = gtk.combo_box_new_text()
                #thbox.pack_start(self.cb_path, True)
                #self.cb_path.set_sensitive(False)
                #self.cb_path.connect("changed", self.path_selected)


                self.fs_button = hildon.Button(gtk.HILDON_SIZE_AUTO,
                             hildon.BUTTON_ARRANGEMENT_HORIZONTAL)
                self.thbox.pack_start(self.fs_button, False)
                self.fs_button.connect("clicked", self.fullscreen_clicked)
                image = gtk.image_new_from_file("/opt/metromap/data/fullscr.png")
                self.fs_button.set_image(image)
                self.fs_button.set_image_position(gtk.POS_LEFT)
                self.fs_button.show()
                
                
                self.cb_city = hildon.PickerButton(gtk.HILDON_SIZE_AUTO,
                             hildon.BUTTON_ARRANGEMENT_HORIZONTAL)
                self.cb_city.set_title(self.label_city_text[0])
                self.menu.append(self.cb_city)
                self.cb_city_selector = hildon.TouchSelector(text=True)
                self.citynow = 0
                i = 0
                for c in self.citylist:
                        self.cb_city_selector.append_text(c[0])
                        if c[1] == citynow:
                                self.citynow = i
                        i += 1
                self.cb_city_selector.set_active(0, self.citynow)
                if len(self.citylist) < 2:
                        self.cb_city.set_sensitive(False)
                self.cb_city_selector.connect("changed", self.city_selected)
                self.cb_city.set_selector(self.cb_city_selector)
                self.cb_city.show()
				
				
                self.cb_dtime = hildon.PickerButton(gtk.HILDON_SIZE_AUTO,
                             hildon.BUTTON_ARRANGEMENT_HORIZONTAL)
                self.cb_dtime.set_title(self.label_time_text[0])
                self.menu.append(self.cb_dtime)
                self.cb_dtime_selector = hildon.TouchSelector(text=True)
                for c in _('Day'), _('Night'):
                    self.cb_dtime_selector.append_text(c)
                self.cb_dtime_selector.set_active(0, 0)
                self.cb_dtime_selector.connect("changed", self.dtime_selected)
                self.cb_dtime.set_selector(self.cb_dtime_selector)
                self.cb_dtime.show()
                
                
                if self.zoomlist and len(self.zoomlist):
                        self.cb_zoom = hildon.PickerButton(gtk.HILDON_SIZE_AUTO,
                             hildon.BUTTON_ARRANGEMENT_HORIZONTAL)
                        self.cb_zoom.set_title('Zoom')
                        self.menu.append(self.cb_zoom)
                        self.cb_zoom_selector = hildon.TouchSelector(text=True)
                        a = 0
                        for c in self.zoomlist:
                                self.cb_zoom_selector.append_text(c[0])
                                if c[1] == self.zoomnow:
                                        a = self.zoomlist.index(c)
                        self.cb_zoom_selector.set_active(0, a)
                        self.cb_zoom_selector.connect("changed", self.zoom_selected)
                        self.cb_zoom.set_selector(self.cb_zoom_selector)
                        self.cb_zoom.show()
                
                
                self.maxerror_cb = hildon.PickerButton(gtk.HILDON_SIZE_AUTO,
                                  hildon.BUTTON_ARRANGEMENT_HORIZONTAL)
                self.maxerror_cb.set_title('Time delta')
                self.menu.append(self.maxerror_cb)
                self.maxerror_cb_selector = hildon.TouchSelector(text=True)
                a = 0
                for c in range(100):
                    self.maxerror_cb_selector.append_text(str(c))
                self.maxerror_cb_selector.set_active(0, 5)
                label = gtk.Label(_("Time delta:"))
                self.maxerror_cb_selector.connect("changed", self.maxerror_selected)
                self.maxerror_cb.set_selector(self.maxerror_cb_selector)
                self.maxerror_cb.show()
                
                self.progress_bar = gtk.ProgressBar()
                vbox.pack_end(self.progress_bar, expand=False, fill=False)
                
                self.big_vbox = vbox
                
                self.button_help = hildon.Button(gtk.HILDON_SIZE_AUTO,
                             hildon.BUTTON_ARRANGEMENT_HORIZONTAL)
                self.button_help.set_title('About')
                self.menu.append(self.button_help)
                self.button_help.connect("clicked", self.help_clicked)
                self.button_help.show()
                
                self.button_compact = hildon.Button(gtk.HILDON_SIZE_AUTO,
                             hildon.BUTTON_ARRANGEMENT_HORIZONTAL)
                self.button_compact.set_title('Compact view')
                self.menu.append(self.button_compact)
                self.compact_clicked(None)
                self.button_compact.connect("clicked", self.compact_clicked)
                self.button_compact.show()

                self.win.show_all()
                self.progress_bar.hide()
                
                if maximize:
                        self.win.maximize()

        def get_win():
            return self.win
        
        def menu_callback(self, data, st=None):
                if data == "help":
                        self.help_clicked(None)
                if data == "info":
                        if st != None:
                                self.show_st_info(st)
                elif data == "compact":
                        self.compact_clicked(None)
                elif data == "quit":
                        self.quit_clicked(None)
                elif data.startswith("zoom"):
                        self.cb_zoom.set_active(map(lambda a: a[1], self.zoomlist).index(float(data[5:])))
                        self.zoom_selected(None)

        def show_st_info(self, st):
                if self.show_info_cb:
                        self.show_info_cb(st)

        def quit_clicked(self, widget):
                if self.quit_cb:
                        self.quit_cb(None)

        def help_clicked(self, widget):
                if not self.help_win or not self.help_win.shown():
                        self.help_win = SimpleMessageBox(self.progname, 'About', 'About', self.helptext, gtk.STOCK_OK, self.win)
                else:
                        x, y = self.win.get_position()
                        w, h = self.win.get_size()
                        dw, dh = self.help_win._w.get_size()
                        self.help_win._w.move(x + (w - dw) / 2, y + (h - dh) / 2)
                        self.help_win.focus()

        def one_button_clicked(self, widget):
                self.one_button = self.button_one_button.get_active()
                if self.one_button_cb:
                        self.one_button_cb(self.one_button)

        def fullscreen_clicked(self, foo):
            if self.is_fullscreen:
                self.win.unfullscreen()
                self.is_fullscreen = False
                image = gtk.image_new_from_file("/opt/metromap/data/fullscr.png")
                self.fs_button.set_image(image)
                self.fs_button.set_image_position(gtk.POS_LEFT)
            else:
                self.win.fullscreen()
                self.is_fullscreen = True
                image = gtk.image_new_from_file("/opt/metromap/data/unfullscr.png")
                self.fs_button.set_image(image)
                self.fs_button.set_image_position(gtk.POS_LEFT)
        
        def compact_clicked(self, widget):
                self.compact_mode = not self.compact_mode
                if not self.compact_mode:
                        self.cb_path.show()
                        self.fs_button.show()
                        self.win.unfullscreen()
                        self.button_compact.set_title('Compact view')
                else:
                        self.cb_path.hide()
                        self.fs_button.hide()
                        self.win.fullscreen()
                        self.button_compact.set_title('Normal view')

        def __configure_win_cb(self, widget, event):
                self.xsize, self.ysize = widget.get_size()

        def set_da(self, da):
                if self.Swin:
                        self.big_vbox.remove(self.Swin.swin)
                self.Swin = SWin(da)
                self.big_vbox.pack_start(self.Swin.swin, True)
                self.Swin.swin.show_all()

        def set_one_button_cb(self, cb):
                self.one_button_cb = True

        def set_path_cb(self, cb):
                self.path_cb = cb

        def set_city_cb(self, cb):
                self.city_cb = cb

        def set_dtime_cb(self, cb):
                self.dtime_cb = cb

        def set_station_cb(self, cb):
                self.station_cb = cb

        def set_delta_cb(self, cb):
                self.delta_cb = cb

        def set_zoom_cb(self, cb):
                self.zoom_cb = cb

        def set_dtime(self, dtime):
                self.cb_dtime.set_active(dtime)

        def __num_station__(self, text):
                for s in self.stations:
                        if s[0] == text:
                                return s[1]
                return None

        def __text_station__(self, num):
                for s in self.stations:
                        if s[1] == num:
                                return s[0]
                return ""

        def maxerror_selected(self, widget):
                if self.delta_cb:
                        self.delta_cb(int(widget.get_value()))

        def from_selected(self, foo, bar):
                if not self.dont_set_from:
                	    self.cb_from.set_title("")
                	    num = self.__num_station__(self.cb_from.get_selector().get_current_text())
                	    if num != None:
                                self.station_cb(num, True)

        def to_selected(self, foo, bar):
                if not self.dont_set_to:
                	    self.cb_to.set_title("")
                	    num = self.__num_station__(self.cb_to.get_selector().get_current_text())
                	    if num != None:
                                self.station_cb(num, False)

        def set_st_list(self, stations):
                self.stations = stations

                self.station_numbers_map = dict()
                self.station_numbers_map.clear()
                if stations != None:
                    i = 0
                    for st in self.stations:
                        ret = self.station_numbers_map.setdefault(st[1], i)
                        if ret == i:
                            i = i + 1

                self.dont_set_from = True
                self.dont_set_to = True
                for cb in self.cb_from, self.cb_to:
                        #cb.child.set_text("")
                        #for p in xrange(len(cb.get_model()), 0, -1):
                        #        cb.remove_text(p - 1)
                        for s in stations:
                                cb.get_selector().append_text(s[0])
                self.dont_set_from = False
                self.dont_set_to = False

        def set_from(self, station):
                self.dont_set_from = True
                self.cb_from.set_title("")
                if self.station_numbers_map.get(station):
                    self.cb_from.get_selector().set_active(0, int(self.station_numbers_map.get(station)))
                self.dont_set_from = False

        def set_to(self, station):
                self.dont_set_to = True
                self.cb_to.set_title("")
                if self.station_numbers_map.get(station):
                    self.cb_to.get_selector().set_active(0, int(self.station_numbers_map.get(station)))
                self.dont_set_to = False

        def set_path_list(self, plist):
                self.cb_path.destroy()
                self.cb_path_selector.destroy()

                self.cb_path = hildon.PickerButton(gtk.HILDON_SIZE_AUTO,
                             hildon.BUTTON_ARRANGEMENT_HORIZONTAL)
                self.cb_path.set_title("")
                self.cb_path_selector = hildon.TouchSelector(text=True)
                self.cb_path.set_selector(self.cb_path_selector)
                self.cb_path_selector.connect("changed", self.path_selected)
                self.thbox.pack_start(self.cb_path, True)
                self.thbox.reorder_child(self.cb_path, 0)
                self.cb_path.show()
                
                for p in plist:
                        self.cb_path_selector.append_text(p)
                if len(plist) > 0:
                        self.dont_set_path = True
                        self.cb_path.set_active(0)
                        self.dont_set_path = False
                else:
			pass
                if len(plist) > 1:
                        self.cb_path.set_sensitive(True)
                else:
                        self.cb_path.set_sensitive(False)

        def path_selected(self, foo, bar):
                if self.path_cb and not self.dont_set_path:
                        self.path_cb(self.cb_path.get_active())

        def city_selected(self, foo, bar):
                if self.city_cb and not self.dont_set_city:
                    self.city_cb(self.citylist[self.cb_city.get_active()][1])

                self.cb_to.destroy()
                self.cb_to = self.create_ebox(self.stations)
                self.cb_to.set_title("To")
                self.cb_to.get_selector().connect("changed", self.to_selected)
                self.menu.prepend(self.cb_to)
                self.cb_to.show()

                self.cb_from.destroy()
                self.cb_from = self.create_ebox(self.stations)
                self.cb_from.set_title("From")
                self.cb_from.get_selector().connect("changed", self.from_selected)
                self.menu.prepend(self.cb_from)
                self.cb_from.show()



        def set_win_title(self, title):
                self.win.set_title(title)

        def dtime_selected(self, foo, bar):
                if self.dtime_cb:
                        self.dtime_cb(self.cb_dtime.get_active())

        def zoom_selected(self, foo, bar):
                if self.zoom_cb:
                        self.zoom_cb(self.zoomlist[self.cb_zoom.get_active()][1])

        def create_ebox(self, names):
		        ce = hildon.TouchSelectorEntry(text=True)
		        if names:
		            for item in names:
		                ce.append_text(item[0])
		        picker_button = hildon.PickerButton(gtk.HILDON_SIZE_AUTO,
		                                   hildon.BUTTON_ARRANGEMENT_HORIZONTAL)
		        picker_button.set_selector(ce)
		        return picker_button

        def progress_start(self, text="", percentage=0):
                self.progress_set_percentage(percentage)
                self.progress_set_text(text)
                self.progress_bar.show()
                self.update()

        def progress_set_percentage(self, percentage):
                percentage = max(percentage, 0)
                percentage = min(percentage, 100)
                self.progress_bar.set_fraction(percentage / 100.0)
                self.update()

        def progress_set_text(self, text):
                self.progress_bar.set_text(text)
                self.update()

        def progress_end(self):
                self.progress_bar.hide()
                self.update()

        def update(self):
                while gtk.events_pending():
                        gtk.main_iteration_do(True)

#class StationInfo:
#        def __init__(self, st):

if __name__ == '__main__':
        import time
        box = SimpleProgressBox("progress", "test", None)
        box.start("Testing progress window", "Doing something")
        for p in xrange(1, 11):
                box.set_percentage(p * 10)
                time.sleep(0.4)
        box.end()
        print "Sleeping..."
        time.sleep(3)
        box.start("Second test", "Doing something not useful at all")
        for p in xrange(1, 11):
                box.set_percentage(p * 10)
                time.sleep(0.3)
        box.end()
        print "Sleeping again..."
        time.sleep(3)
        box.start("Last test", "Foo")
        for p in xrange(1, 11):
                box.set_percentage(p * 10)
                time.sleep(0.3)

