from com import msgs
from storage import Device, File
from ui.dialog import InputDialog
from GoogleBackend import GoogleBackend
from theme import theme

import os


class CoverStorage(Device):
    """
    Storage device for browsing cover art.
    """

    TYPE = Device.TYPE_IMAGE
    CATEGORY = Device.CATEGORY_WAN
    

    def __init__(self):
    
        self.__backends = [GoogleBackend()]
    
        Device.__init__(self)


    def get_icon(self):
    
        return theme.mb_folder_image
        
        
    def get_prefix(self):
    
        return "covers://"
        
        
    def get_name(self):
    
        return "Cover Art"
        
        
    def get_file(self, path):
    
        f = None
        if (path == "/"):
            f = File(self)
            f.path = "/"
            f.name = "Cover Art"
            f.mimetype = f.DIRECTORY
            f.resource = ""
            f.info = "Browse cover art"
            f.folder_flags = f.ITEMS_COMPACT
        
        return f


    def get_contents(self, folder, begin, end, cb, *args):
    
        if (folder.path == "/"):
            self.__ls_root(folder, begin, end, cb, *args)
    
        elif (folder.path.startswith("/covers")):
            self.__ls_covers(folder, begin, end, cb, *args)
        
        
        
    def __ls_root(self, folder, begin, end, cb, *args):
    
        cnt = 0
        for name, path in [("Search Cover", "/covers"),
                           ("Search Artist", "/artists")]:
            f = File(self)
            f.name = name
            f.path = path
            f.mimetype = f.DIRECTORY
            f.resource = ""
            f.folder_flags = f.ITEMS_COMPACT
            
            if (cnt >= begin and (end == 0 or cnt < end)):
                cb(f, *args)
            cnt += 1
        #end for
        
        cb(None, *args)



    def __ls_covers(self, folder, begin, end, cb, *args):
    
        def on_cover(imgurl):
            if (imgurl):
                f = self.__make_cover(imgurl)
                cb(f, *args)
            else:
                cb(None, *args)
    

        parts = [ p for p in folder.path.split("/") if p ]

        if (len(parts) > 1):
            query = parts[1]
            self.__backends[0].search(query, on_cover)

        else:
            cb(None, *args)

        #end if

        
        
        
    def __make_cover(self, imgurl):
        
        f = File(self)
        f.name = os.path.basename(imgurl)
        f.path = File.pack_path("/covers", imgurl)
        f.resource = imgurl
        f.mimetype = "image/jpeg"
        
        return f

