from com import Component, msgs
from ui.Widget import Widget


class MediaPlayer(Component, Widget):
    """
    Widget for embedding a media player.
    @since: 0.97
    """

    EVENT_MEDIA_POSITION = "media-position"
    EVENT_MEDIA_SCALED = "media-scaled"


    def __init__(self):
    
        self.__player = None
    
        Component.__init__(self)
        Widget.__init__(self)


    def connect_media_position(self, cb, *args):
    
        self._connect(self.EVENT_MEDIA_POSITION, cb, *args)


    def connect_media_scaled(self, cb, *args):
    
        self._connect(self.EVENT_MEDIA_SCALED, cb, *args)


    def __on_media_position(self, pos, total):
    
        self.emit_event(self.EVENT_MEDIA_POSITION, pos, total)


    def __on_media_scaled(self, v):
    
        self.emit_event(self.EVENT_MEDIA_SCALED, v)


    def render_this(self):
    
        x, y = self.get_screen_pos()
        w, h = self.get_size()
        screen = self.get_screen()
        
        screen.fill_area(x, y, w, h, "#000000")
        if (self.__player):
            self.__player.set_geometry(0, 0, w, h)


    def load(self, f):
    
        player = self.call_service(
            msgs.MEDIAWIDGETREGISTRY_SVC_GET_WIDGET,
            self,
            f.mimetype)

        if (self.__player and player != self.__player):
            self.remove(self.__player)

        if (player and player != self.__player):
            self.add(player)
            player.connect_media_position(self.__on_media_position)
            player.connect_media_scaled(self.__on_media_scaled)
            self.__player = player
            
        self.render()
        player.load(f)


    def play_pause(self):
    
        if (self.__player):
            self.__player.play_pause()


    def seek(self, pos):
    
        if (self.__player):
            self.__player.seek(pos)


    def increment(self):
    
        if (self.__player):
            self.__player.increment()


    def decrement(self):
    
        if (self.__player):
            self.__player.decrement()

