import gtk


class OptionDialog(gtk.Dialog):

    def __init__(self):
    
        self.__num_of_options = 0
        self.__choice = -1
    
        gtk.Dialog.__init__(self)
        
        self.__box = gtk.VBox()
        self.add(self.__box)
        self.__box.show()
        

    def add_option(self, icon, label):
    
        def on_choice(self, src, i):
            self.__choice = i
    
        hbox = gtk.HBox()
        hbox.show()
        if (icon):
            img = gtk.Image()
            img.set_from_pixbuf(icon)
            img.show()
            hbox.add(img)
        #end if
        lbl = gtk.Label(label)
        lbl.show()
        hbox.add(lbl)

        btn = gtk.Button()
        self.__box.add(btn)
        btn.show()
        btn.add(hbox)
        btn.connect("clicked", on_choice, self.__num_of_options)
        self.__num_of_options += 1


    def get_choice(self):
    
        return self.__choice

