# -*- coding: utf-8 -*-
'''
MediaBox Home Widget Config
2008-2010(c) Kirill Plyashkevich <ru.spirit@gmail.com>
'''
from advpowcommon.util.config import Config
from advpowcommon.util.singleton import Singleton

class MediaBoxConfig(Config, Singleton):

  def __init__(self, settings_path):
    Config.__init__(self, settings_path)
    Singleton.__init__(self)
    self.__options = {'orientation': ['automatic', 'portrait', 'landscape'],
                      'repeat_mode': ['none', 'one', 'all'],
                      'shuffle_mode': ['none', 'one'],
                      'theme': ['default', 'kuro', 'classic'],
                      'system/keep-display-lit': ['no', 'playing']
                     }

  def get_option(self, key):
    try:
      return self.__options[key]
    except KeyError:
      return None

__mediabox_config_singleton = MediaBoxConfig('/apps/maemo-mediabox')
def get_mediabox_config(): return __mediabox_config_singleton

class MBHWConfig(Config, Singleton):

  def __init__(self, settings_path):
    Config.__init__(self, settings_path)
    Singleton.__init__(self)

__config_singleton = MBHWConfig('/apps/mediabox-home-widget')
def get_config(): return __config_singleton
