# -*- coding: utf-8 -*-
'''
MediaBox Widget
2010(c) Kirill Plyashkevich <ru.spirit@gmail.com>
Maemo 5 home item
'''

import gtk
from abstract import AbstractMediaBoxWidget
from hildondesktop import HomePluginItem

class MediaBoxWidgetMaemo5(AbstractMediaBoxWidget, HomePluginItem):

  def __init__(self):
    AbstractMediaBoxWidget.__init__(self)
    #self.start_command = 'dbus-send --session --dest=com.nokia.HildonDesktop.AppMgr --type=method_call /com/nokia/HildonDesktop/AppMgr com.nokia.HildonDesktop.AppMgr.LaunchApplication string:MediaBox'

  def __super_init__(self):
    HomePluginItem.__init__(self)

  def __custom_init__(self):
    self.settings_dialog_buttons = (gtk.STOCK_SAVE, gtk.RESPONSE_OK)
    self.set_settings(True)
    self.connect('property-notify-event', self.on_current_desktop)
    self.connect('show-settings', self.show_settings_dialog)

  def __show_all__(self):
    self.widget_box.show_all()

  def on_current_desktop(self, widget, event):
    if event.atom == '_HILDON_APPLET_ON_CURRENT_DESKTOP':
      result = event.state.value_nick == 'new-value'
      self.update_widgets_activity(result)
    return False

  def do_realize(self):
    self.screen_changed(self)
    HomePluginItem.do_realize(self)
    return False

def get_hd_plugin_type(): return MediaBoxWidgetMaemo5
