# -*- coding: utf-8 -*-
'''
MediaBox Widget
2008-2009(c) Kirill Plyashkevich <ru.spirit@gmail.com>
Maemo 4 home item
'''

import gtk
from abstract import AbstractMediaBoxWidget
import hildondesktop

class MediaBoxWidgetMaemo4(AbstractMediaBoxWidget, hildondesktop.HomeItem):

  def __init__(self):
    AbstractMediaBoxWidget.__init__(self)

  def __super_init__(self):
    hildondesktop.HomeItem.__init__(self)

  def __custom_init__(self):
    self.settings_dialog_buttons = (gtk.STOCK_SAVE, gtk.RESPONSE_OK, gtk.STOCK_CANCEL, gtk.RESPONSE_DELETE_EVENT)
    self.set_resize_type(hildondesktop.HOME_ITEM_RESIZE_NONE)
    self.connect('screen-changed', self.screen_changed)
    self.connect('expose-event', self.do_expose_event)
    self.connect('background', self.__background)
    self.connect('foreground', self.__foreground)
    self.show_all()

  def __background(self, widget, data=None):
    self.set_size_request(self.size_width, self.size_height)
    self.update_widgets_activity(False)
    return False

  def __foreground(self, widget, data=None):
    self.set_size_request(self.size_width, self.size_height)
    self.update_widgets_activity(True)
    return False

def hd_plugin_get_objects():
  plugin = MediaBoxWidgetMaemo4()
  return [plugin] 
