# -*- coding: utf-8 -*-
'''
MediaBox Desktop Widget
2010(c) Kirill Plyashkevich <ru.spirit@gmail.com>
Widget wrapper
'''

import hildon
from advpowcommon.util.device import device
current_os = device.get_property('OSSO_PRODUCT_RELEASE_NAME')

if current_os == 'OS 2008':
  from mediabox_widget.core.maemo4 import *
elif current_os == 'Maemo 5':
  from mediabox_widget.core.maemo5 import *
  hd_plugin_type = get_hd_plugin_type()

if __name__ == "__main__":
  import sys
  plugin_id = "mediabox_home_widget.console"
  if len(sys.argv) == 2:
    try:
      plugin_id = "mediabox_home_widget.desktop-%s" % int(sys.argv[1])
    except:
      print "Plugin id must be integer"
      sys.exit(-1)

    import gobject, gtk
    from mediabox_widget.core.maemo5 import *
    hd_plugin_type = get_hd_plugin_type()
    gobject.type_register(hd_plugin_type)
    obj = gobject.new(hd_plugin_type, plugin_id=plugin_id)
    obj.show()
    print 'Loaded. Starting gtk.main()'
    gtk.main()
