#include <QWidget>
#include <QThread>
#include "dmtxdecoderthread.h"
#include <QWaitCondition>
#include <qmutex.h>
#include <dmtx.h>
#include <iostream>

#include "common.h"

#include <QFile>
#include <QImage>

using namespace std;

DMTXDecoderThread::DMTXDecoderThread()
{
    this->frame_width = WIDTH; // not really necessary as these won't change during the program
    this->frame_height = HEIGHT;
    this->thread_buffer = (char*)malloc(MAX_VIDEO_WIDTH*MAX_VIDEO_HEIGHT*sizeof(char)*4); // need to account for bpp here, but let's assume 32bit pp is the maximum

    thread_output=0;
    hasFoundBarcode=false;
    doQuit=false;
    isDecoding=false;

    /* Default options */
    opt.codewords = DmtxFalse;
    opt.edgeMin = DmtxUndefined;
    opt.edgeMax = MAX_VIDEO_HEIGHT; // we'll need to change this if the image size changes!
    opt.scanGap = 2;
    opt.timeoutMS = 1000;
    opt.newline = DmtxFalse;
    opt.page = DmtxUndefined;
    opt.squareDevn = DmtxUndefined;
    opt.dpi = DmtxUndefined;
    opt.sizeIdxExpected = DmtxSymbolShapeAuto;
    opt.edgeThresh = 5;
    opt.xMin = NULL;
    opt.xMax = NULL;
    opt.yMin = NULL;
    opt.yMax = NULL;
    opt.correctionsMax = DmtxUndefined;
    opt.diagnose = DmtxFalse;
    opt.mosaic = DmtxFalse;
    opt.stopAfter = 1; // we may want to increase this if we decide to return more than one barcode
    opt.pageNumbers = DmtxFalse;
    opt.corners = DmtxFalse;
    opt.shrinkMin = 1;
    opt.shrinkMax = 1;
    opt.unicode = DmtxFalse;
    opt.verbose = DmtxFalse;

}

DMTXDecoderThread::~DMTXDecoderThread()
{
    this->doQuit=true;
    this->thread_run.wakeOne();
}


void DMTXDecoderThread::run()
{
    while(true){

        // this allows the main program to block us until data is available for us
        //this->wait_mutex.lock();
        this->thread_run.wait(&this->wait_mutex); // wait here until signalled
        //this->wait_mutex.unlock();

        // see if we should quit
        if(this->doQuit==true){
            free(this->thread_buffer);
            return;
        }

        // call our function
        this->wait_mutex.lock();
        this->isDecoding=true;
        this->hasFoundBarcode = libdmtx_analyse_image();
        this->isDecoding=false;
        this->wait_mutex.unlock();

        // return data in our global vars
        // reset our timer, hopefully this should be threadsafe, etc...

    }

}


/* Analyse the image data */
int DMTXDecoderThread::libdmtx_analyse_image()
{

//    const char *buf = (char *)this->thread_buffer;
//    unsigned int height = this->frame_height;
//    unsigned int width = this->frame_width;
//    int bpp = 24; //this->frame_bpp;

//    QImage::Format format = QImage::Format_RGB888; // we can't always assume this.....
//    QImage *qi = new QImage((uchar*)buf, width, height, format); //(buffer, width, height, width, format);
//    qi->save("/home/user/dmtxthreadimage.png");

//    QFile file("/home/user/dmtxthreadimage.raw");
//    file.open(QIODevice::WriteOnly);
//    file.write(buf, height*width*bpp/8); // 4 to make it larger than we want, write all the data
//    file.close();



    //GdkPixbuf *pixbuf = NULL;
    //GError *error = NULL;
    //unsigned int bpp;
    //const char *directory;
    //GString *filename;
    //unsigned int base_len, i;
    //struct stat statbuf;
    //int ret,ii;
    //int ean[14];
    //DmtxEncode     *enc;
    DmtxImage      *img;
    DmtxDecode     *dec;
    DmtxRegion     *reg;
    DmtxMessage    *msg;
    DmtxTime        timeout;

//    fprintf(stdout, "Entered libdmtx_analyse_image()\n");

    img = dmtxImageCreate((unsigned char*)thread_buffer, frame_width, frame_height, frame_fourcc); // DmtxPack8bppK
    //assert(img != NULL);
//    cout << "libdmtx_analyse_image(): done dmtxImageCreate" << endl;

    dmtxImageSetProp(img, DmtxPropImageFlip, DmtxFlipNone);



    dec = dmtxDecodeCreate(img, 1);

    int err = SetDecodeOptions(dec, img, &this->opt);
    Q_UNUSED(err)

    //assert(dec != NULL);
//    cout << "libdmtx_analyse_image(): done dmtxDecodeCreate" << endl;

    timeout = dmtxTimeAdd(dmtxTimeNow(), 1000); // give it 100 ms to analyse...
    reg = dmtxRegionFindNext(dec, &timeout);

//    cout << "libdmtx_analyse_image(): done dmtxRegionFindNext" << endl;
    if(reg != NULL) {
        msg = dmtxDecodeMatrixRegion(dec, reg, DmtxUndefined);
//        cout << "libdmtx_analyse_image(): done dmtxDecodeMatrixRegion" << endl;
        if(msg != NULL) {
            cout << "Found datamatrix barcode!" << endl;
            //fputs("output: \"", stdout);
            //fwrite(msg->output, sizeof(unsigned char), msg->outputIdx, stdout);
            //fputs("\"\n", stdout);

            if (thread_output){
                free(thread_output);
                thread_output=0;
            }

            thread_output = (char *)malloc((msg->outputIdx+1) * sizeof (char));
            memcpy(thread_output, msg->output, msg->outputIdx);
            thread_output[msg->outputIdx +1] = 0; // add the null terminator for the char array

            dmtxMessageDestroy(&msg);
            dmtxRegionDestroy(&reg);
            dmtxDecodeDestroy(&dec);
            dmtxImageDestroy(&img);
            return TRUE;
        }
        dmtxRegionDestroy(&reg);
    }

    dmtxDecodeDestroy(&dec);
    dmtxImageDestroy(&img);
    return FALSE;
}

DmtxPassFail DMTXDecoderThread::SetDecodeOptions(DmtxDecode *dec, DmtxImage *img, UserOptions *opt)
{
   int err;

#define RETURN_IF_FAILED(e) if(e != DmtxPass) { return DmtxFail; }

   err = dmtxDecodeSetProp(dec, DmtxPropScanGap, opt->scanGap);
   RETURN_IF_FAILED(err)

   if(opt->edgeMin != DmtxUndefined) {
      err = dmtxDecodeSetProp(dec, DmtxPropEdgeMin, opt->edgeMin);
      RETURN_IF_FAILED(err)
   }

   if(opt->edgeMax != DmtxUndefined) {
      err = dmtxDecodeSetProp(dec, DmtxPropEdgeMax, opt->edgeMax);
      RETURN_IF_FAILED(err)
   }

   if(opt->squareDevn != DmtxUndefined) {
      err = dmtxDecodeSetProp(dec, DmtxPropSquareDevn, opt->squareDevn);
      RETURN_IF_FAILED(err)
   }

   err = dmtxDecodeSetProp(dec, DmtxPropSymbolSize, opt->sizeIdxExpected);
   RETURN_IF_FAILED(err)

   err = dmtxDecodeSetProp(dec, DmtxPropEdgeThresh, opt->edgeThresh);
   RETURN_IF_FAILED(err)

   if(opt->xMin) {
      err = dmtxDecodeSetProp(dec, DmtxPropXmin, ScaleNumberString(opt->xMin, img->width));
      RETURN_IF_FAILED(err)
   }

   if(opt->xMax) {
      err = dmtxDecodeSetProp(dec, DmtxPropXmax, ScaleNumberString(opt->xMax, img->width));
      RETURN_IF_FAILED(err)
   }

   if(opt->yMin) {
      err = dmtxDecodeSetProp(dec, DmtxPropYmin, ScaleNumberString(opt->yMin, img->height));
      RETURN_IF_FAILED(err)
   }

   if(opt->yMax) {
      err = dmtxDecodeSetProp(dec, DmtxPropYmax, ScaleNumberString(opt->yMax, img->height));
      RETURN_IF_FAILED(err)
   }

#undef RETURN_IF_FAILED

   return DmtxPass;
}

int DMTXDecoderThread::ScaleNumberString(char *s, int extent)
{
   int err;
   int numValue;
   int scaledValue;
   char *terminate;

   //assert(s != NULL);

   err = StringToInt(&numValue, s, &terminate);
   if(err != DmtxPass){
        //qDebug() << "Integer value required";
        return 0; // need to fix this as it's an error, we should let the calling code know
    }

   scaledValue = (*terminate == '%') ? (int)(0.01 * numValue * extent + 0.5) : numValue;

   if(scaledValue < 0)
      scaledValue = 0;

   if(scaledValue >= extent)
      scaledValue = extent - 1;

   return scaledValue;
}

#undef ISDIGIT
#define ISDIGIT(n) (n > 47 && n < 58)

DmtxPassFail DMTXDecoderThread::StringToInt(int *numberInt, char *numberString, char **terminate)
{
   long numberLong;

   if(!ISDIGIT(*numberString)) {
      *numberInt = DmtxUndefined;
      return DmtxFail;
   }

   errno = 0;
   numberLong = strtol(numberString, terminate, 10);

   while(isspace((int)**terminate))
      (*terminate)++;

   if(errno != 0 || (**terminate != '\0' && **terminate != '%')) {
      *numberInt = DmtxUndefined;
      return DmtxFail;
   }

   *numberInt = (int)numberLong;

   return DmtxPass;
}
