#include <QtDBus>
#include <QtGui>

#include "providerwindow.h"
#include "ui_providerwindow.h"

#include "searchprovider.h"
#include "wrplugin.h"
#include "editproviderdialog.h"

ProviderWindow::ProviderWindow(QWidget *parent, WrPlugin *plugin) :
    QMainWindow(parent),
    ui(new Ui::ProviderWindow)
{
    qDebug() << "ProviderWindow::ProviderWindow()";
    ui->setupUi(this);
    ui->menuMenu->setTitle("");
    model = new QStandardItemModel(this);
    ui->tblProviders->setModel(model);
    ui->tblProviders->setProperty("FingerScrollable", true);
    ui->tblProviders->horizontalHeader()->setResizeMode(QHeaderView::Stretch);
    refreshProviders();
    setAttribute(Qt::WA_Maemo5StackedWindow);
}

ProviderWindow::~ProviderWindow()
{
    delete ui;
}

void ProviderWindow::refreshProviders() {
    qDebug() << "Refreshing providers";
    model->clear();
    this->plugin = plugin;
    int row = 0;
    for(int i = 0; i<plugin->searchProviders().count(); i++) {
        SearchProvider* provider = plugin->searchProviders().at(i);
        QVariantHash itemData;
        itemData.insert("baseUri", provider->baseUri);
        itemData.insert("providerId", i);

        QStandardItem *providerItem = new QStandardItem(provider->name);
        QStandardItem *editItem = new QStandardItem("Edit");
        QStandardItem *removeItem = new QStandardItem("Remove");

        providerItem->setData(itemData);
        editItem->setData(itemData);
        removeItem->setData(itemData);

        model->setItem(row, 0, providerItem);
        model->setItem(row, 1, editItem);
        model->setItem(row, 2, removeItem);
        row++;
    }
    qDebug() << "Providers added";
}

void ProviderWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void ProviderWindow::on_tblProviders_clicked(QModelIndex index)
{
    qDebug() << "Clicked on table";
    QStandardItem *item = model->itemFromIndex(index);
    QVariantHash itemData = item->data().toHash();
    QString baseUri = itemData.value("baseUri").toString();
    int providerId = itemData.value("providerId").toInt();
    qDebug() << "Checking column";
    if(item->column() == 0) {
        QString uri = baseUri.replace("%s", QUrl::toPercentEncoding(plugin->barcodeText)); // replace %s with barcodeText
        QDBusInterface *interface = new QDBusInterface("com.nokia.osso_browser","/com/nokia/osso_browser/request","com.nokia.osso_browser");
        interface->call("open_new_window",uri);
    } else if(item->column() == 1) {
        EditProviderDialog *dialog = new EditProviderDialog(this, plugin->searchProviders().at(providerId));
        if(dialog->exec() == QDialog::Accepted) {
            QList<SearchProvider*> providers = plugin->searchProviders();
            providers.at(providerId)->baseUri = dialog->providerAddress();
            providers.at(providerId)->name = dialog->providerName();
            plugin->setSearchProviders(providers);
        }
    } else if(item->column() == 2) {
        QMessageBox *prompt = new QMessageBox(this);
        prompt->setWindowTitle("Remove search provider?");
        prompt->setText("Are you sure you want to remove this search provider?");
        prompt->setStandardButtons(QMessageBox::Ok | QMessageBox::Cancel);
        if(prompt->exec() == QMessageBox::Ok) {
            plugin->removeSearchProvider(plugin->searchProviders().at(providerId));
        }
    }
    qDebug() << "done click";
//    this->close();
}

void ProviderWindow::on_actionAdd_Custom_Search_triggered()
{
    EditProviderDialog *dialog = new EditProviderDialog(this);
    if(dialog->exec() == QDialog::Accepted) {
        plugin->addSearchProvider(new SearchProvider(dialog->providerName(), dialog->providerAddress()));
    }
}
