#include "wrsink.h"
#include <mbarcode-qt/plugininterfaces.h>
#include <mbarcode-qt/pluginaction.h>

#include <QtCore>
#include <QProcess>
#include <QtDBus>
#include <QDesktopServices>

#include "providerwindow.h"
#include "wrplugin.h"

WrSink::WrSink(const PluginInterface *interface) : PluginAction(interface) {
    image = QImage(":/images/globe.png");
    image = image.scaledToHeight(48, Qt::SmoothTransformation);
}

QString WrSink::getInformativeText() {
    return "Search the web for " + barcodeText.left(20) + "...";
}

void WrSink::clickAction(QWidget *parentWindow) {
    ProviderWindow *win = new ProviderWindow(parentWindow, plugin);
    win->show();
}

void WrSink::setPlugin(WrPlugin *plugin) {
    this->plugin = plugin;
}

QImage WrSink::getImage() {
    return image;
}
