#ifndef TESTSINK_H
#define TESTSINK_H

#include <QtCore>
#include <QImage>
#include <mbarcode-qt/plugininterfaces.h>
#include <mbarcode-qt/pluginaction.h>

class WrPlugin;

class WrSink : public QObject, public PluginAction
{
    Q_OBJECT
public:
    // inherited virtuals
    WrSink(const PluginInterface *interface);
    QString getName() {return "Webrequest sink";}
    QString getText() {return "Search the Web";}
    QString getInformativeText();
    bool isReady();
    void clickAction(QWidget *parentWindow);
    void setPlugin(WrPlugin* plugin);
    QImage getImage();
    // other
    QString barcodeText;
private:
    bool ready;
    QString buttonText;
    int type;
    WrPlugin *plugin;
    QImage image;
    // other
};

#endif // TESTSINK_H
