#ifndef TESTPLUGIN_H
#define TESTPLUGIN_H

#include <QObject>
#include <QStringList>
#include <QImage>

#include <mbarcode-qt/plugininterfaces.h>

class SinkPlugin;
class MainWindow;
class WrSink;
class SearchProvider;

class WrPlugin : public QObject, public PluginInterface
{
    Q_OBJECT
    Q_INTERFACES(PluginInterface)
public:
    void initInterface(MainWindow *parent);
    QSet<SinkPlugin*> getSinkPlugins();
    QString getName() {return "Webrequest";}
    QSettings *settings;
    QList<SearchProvider*> searchProviders();
    void setSearchProviders(QList<SearchProvider*> providers);
    void saveSearchProviders();
    void addSearchProvider(SearchProvider* provider);
    void removeSearchProvider(SearchProvider* provider);
    QString barcodeText;
private slots:
    void barcodeAnalysed(QString barcodeType, QString barcodeData);
private:
    MainWindow *parent;
    QString url;
    WrSink *sink;
    QList<SearchProvider*> providers;
};

#endif //TESTPLUGIN_H
