#include "wrsink.h"
#include <mbarcode-qt/plugininterfaces.h>
#include <mbarcode-qt/sinkplugin.h>

#include <QtCore>
#include <QProcess>
#include <QtDBus>
#include <QDesktopServices>

WrSink::WrSink(const PluginInterface *interface) : SinkPlugin(interface) {
    ready = false;
}

QString WrSink::getText()
{
    return "Search with Google";
}

void WrSink::clickAction(QWidget *parentWindow) {
    QString uri = "http://www.google.no/search?q=" + QUrl::toPercentEncoding(barcodeText);
    QDBusInterface *interface = new QDBusInterface("com.nokia.osso_browser","/com/nokia/osso_browser/request","com.nokia.osso_browser");
    interface->call("open_new_window",uri);
}

void WrSink::barcodeAnalysed(QString barcodeType, QString barcodeData) {
    ready = true;
    this->barcodeText = barcodeData;
}

bool WrSink::isReady() {
    return ready;
}
