#ifndef TESTSINK_H
#define TESTSINK_H

#include <QtCore>
#include <QImage>
#include <mbarcode-qt/plugininterfaces.h>
#include <mbarcode-qt/pluginaction.h>

class QrSink : public QObject, public PluginAction
{
    Q_OBJECT
public:
    enum barcodeType {
        Unknown=0,
        Email,
        URL,
        SMS,
        MMS,
        PhoneNumber,
        vCard,
        BizCard,
        iMode,
        iModeMECARD,
        Geo,
        YouTube,
        Install,
        Ovi
    };
    // inherited virtuals
    QrSink(const PluginInterface *interface);
    QString getName() {return "QR-code sink plugin";}
    QString getText();
    QImage getImage();
    QString getInformativeText();
    bool isReady();
    void clickAction(QWidget *parentWindow);
    // other
    //QString url;
private slots:
    void barcodeAnalysed(QString barcodeType, QString barcodeData);
private:
    void openGeneric(QString uri);
    void addVCard(QString user_data);
    void openInstallFile(QString data);
    void openBrowser(QString uri);
    void addMECARD(QString user_data);

    bool ready;
    QString buttonText;
    QString barcodeText;
    QString barcodeInformativeText;
    int type;

    QImage image;
};

#endif // TESTSINK_H
