#ifndef PYTHONQTWRAPPERPLUGIN_H
#define PYTHONQTWRAPPERPLUGIN_H

#include <Python.h>
#include <shiboken.h>
#include <shiboken/conversions.h>

#include <mbarcode-qt/plugininterfaces.h>
#include <mbarcode-qt/pluginaction.h>

#include <QObject>
#include <QStringList>

#define PLUGIN_COUNT_LIMIT 6

class PluginAction;
class MainWindow;
class PythonQTWrapperSink;

class PythonQTWrapperPlugin : public QObject, public PluginInterface
{
    Q_OBJECT
    Q_INTERFACES(PluginInterface)
public:
    //PythonQTWrapperPlugin();
    ~PythonQTWrapperPlugin();
    void initInterface(QWidget *parent);
    QSet<PluginAction*> getPluginActions();
    bool hasSettingsWindow() {return false;};
    //QMainWindow* getSettingsWindow(QWidget *parent);
    QString getName();

    QTimer *checkTimer;
private:
    MaemoBarcodeWindow *parent;
    bool initialised;

    int PluginUpdateCounter;
    QList<PluginAction*> addedPlugins;

    // this is a list of the sinks provided by all the ini files
    QList<PythonQTWrapperSink *> sinks;
    //PyObject *_compiledClass;
    //QList<PyObject *> pythonInstances;

private slots:
    void checkPlugins();

};

#endif // PYTHONQTWRAPPERPLUGIN_H
