import sys
from PySide import QtGui, QtCore

class example_plugin(QtGui.QWidget): # class name and filename must match!

    def __init__(self, parent=None):
        QtGui.QWidget.__init__(self, parent)
        self.ready = False
        self.widget = None
        self.type = ""
        self.data = ""

    def getName(self):
        return "python_test_sink" # this is not displayed, might be used in the future internally

    def getText(self):
        return "Python Test Sink" # this is displayed on the button

    def getImage(self):
        # return an image to be displayed on the button
        return Nothing

    def getInformativeText(self):
        return "Informative text"

    def isReady(self):
        return self.ready

    def clickAction(self): # parent window too?
        # this is the callback that indicates the button has been pressed
        # do whatever processing on the barcode data
        # add more detail here, e.g. opening a window to display stuff to the user
        
        self.widget = QtGui.QWidget() #QMainWindow()
        self.widget.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow)
        
        labelData = QtGui.QLabel("Data: " + self.data)
        labelType = QtGui.QLabel("Type: " + self.type)
        self.button = QtGui.QPushButton("Ok")
        print self.connect(self.button, QtCore.SIGNAL('clicked()'), 
            self, QtCore.SLOT('doclose()'))

        vBox = QtGui.QVBoxLayout()
        vBox.addWidget(labelData)
        vBox.addWidget(labelType)
        vBox.addWidget(self.button)
        self.widget.setLayout(vBox)
        
        self.widget.setWindowTitle('Python plugin')
        self.widget.show()
        print "this is python!"

        self.timer = QtCore.QTimer(self)
        self.connect(self.timer, QtCore.SIGNAL('timeout()'), 
             self, QtCore.SLOT('doupdate()'))
        self.timer.setInterval(1000)
        self.timer.start()

        #QtGui.QMessageBox.information(widget, self.data, self.type)

    def barcodeAnalysed(self, barcodeType, barcodeData):
        # see if we want to handle this particular barcode
        # return true or false depending on whether we like the content
        self.ready = True
        self.data = barcodeData
        self.type = barcodeType

    def doclose(self):
        print 'close'
        #self.destroy()

    def doupdate(self):
        print 'timer'

