#include <Python.h>

#include <mbarcode-qt/plugininterfaces.h>
#include <mbarcode-qt/pluginaction.h>
#include <mbarcode-qt/maemobarcodewindow.h>

#include "pythonqtwrapperplugin.h"
#include "pythonqtwrappersink.h"

#include <QString>
#include <shiboken.h>
#include <iostream>

using namespace std;

static void doDecRef(PyObject* object)
{
    Py_DECREF(object);
}

typedef QSharedPointer<PyObject> pyptr;

pyptr py(PyObject* object)
{
    return pyptr(object, doDecRef);
}


// initialisation, including setting up the slot hooks between this class and the sink itself
void PythonQTWrapperPlugin::initInterface(QWidget *parent) {

    // this is where we find the Python plugins and ask them what types of barcodes they want.
    // we generate one sink per file, adding into each of the sink classes the appropriate name information
    // as well as the barcode types each wants, and any match !match information they tell us about

    // should this is hardcoded...?
    QDir d("/usr/share/mbarcode/plugins/pythonqt/");
    QStringList filter;
    filter << "*.py";
    QStringList list = d.entryList(filter);


    // we need to init the PythonQt business, but if there are no Python plugins installed, we shoudn't bother as it wastes time and memory
    if (list.size()>0){
        cout << "Python plugins found, about to initialise Python runtime." << endl;
        this->initialised=true;
        Py_Initialize();

        Shiboken::init();

//        SbkObject* sbkSelf = reinterpret_cast<SbkObject*>(self);
//        Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType<QCoreApplication>(), qApp);

//        Shiboken::Object::setValidCpp(sbkSelf, true);
//        Shiboken::Object::setHasCppWrapper(sbkSelf, true);
//        Shiboken::Object::releaseOwnership(sbkSelf);

//        Shiboken::BindingManager::instance().registerWrapper(sbkSelf, qApp);
//        PySide::Signal::updateSourceObject(self);
//        qApp->metaObject();


        //Shiboken::BindingManager::instance().registerWrapper(reinterpret_cast<SbkBaseWrapper*>(self), qApp);
        //Py_INCREF(self);
    }else{
        cout << "No Python plugins found, returning..." << endl;
        return; //and make sure we don't get called again
    }

    cout << "PythonQTWrapperPlugin::initInterface() found " << QString("%1").arg(list.size()).toStdString() << " possible plugins." << endl;


    // Create namespace.
    PyObject *dict = PyDict_New();
    PyDict_SetItemString(dict, "__builtins__", PyEval_GetBuiltins());
    if ( PyErr_Occurred() )
    {
        PyErr_Print();
        return;
    }



    for(int i=0; i<list.size(); ++i)
    {
        QFile f(d.absolutePath() + "/" + list.at(i)); // will break on other platforms

        if(!f.open(QIODevice::ReadOnly | QIODevice::Text))
        {
            cout << "Could not open " << f.fileName().toStdString() << endl;
            continue;
        }
        QByteArray src = f.readAll();
        f.close();


        // Compile code.
        QString fileString = QString("<%1>").arg(f.fileName());
        PyObject *compiledCode = Py_CompileStringFlags(src.data(), fileString.toAscii().data(), Py_file_input, NULL);
        if(!compiledCode)
        {
            if ( PyErr_Occurred() )
                PyErr_Print();
            cout << "Failed to compile code for" << fileString.toStdString() << endl;
            continue;
        }
        qDebug() << "Compiled code";

        // Evaluate code to create class.
        PyObject *result = PyEval_EvalCode(reinterpret_cast<PyCodeObject*>(compiledCode), dict, dict);
        Py_DECREF(compiledCode);
        if(!result)
        {
            if ( PyErr_Occurred() )
                PyErr_Print();
            cout << "Evaluation error of" << fileString.toStdString() << endl;
            return;
        }
        Py_DECREF(result);

        qDebug() << "Evaluated code";

        // Get class object.
        PyObject *_compiledClass = PyDict_GetItemString(dict, QFileInfo(f).baseName().toAscii()); // class has same name as file minus the .py
        if(!_compiledClass)
        {
            if ( PyErr_Occurred() )
                PyErr_Print();
            cout << "Could not find class" << endl;
            continue;
        }
        //Py_INCREF(_compiledClass);
        qDebug() << "Got class object";



//        QObject *obj = NULL; //new QObject();
//        PyObject* pyObj = NULL; //Shiboken::Converter<QObject*>::toPython(obj);
//        QWidget *widg = new QWidget(this->parent);
//        PyObject* pyWidg = Shiboken::Converter<QWidget*>::toPython(widg);

        qDebug() << "Done Shiboken::Converter calls";


        //PyObject *args = Py_BuildValue("oo", pyObj, pyWidg);

        qDebug() << "Built args";

        PyObject *sinkInstance = PyObject_CallObject(_compiledClass, NULL); //args

        qDebug() << "Called object";

        if(!sinkInstance)
        {
            if ( PyErr_Occurred() )
                PyErr_Print();
            cout << "Failed to create instance of Python class" << endl;
            continue;
        }else{

            PythonQTWrapperSink *s = new PythonQTWrapperSink(this, sinkInstance); //obj, widg
            sinks.append(s);
            // I guess we'll need to do this for each sink too.
            connect(parent, SIGNAL(barcodeAnalysedSignal(QString,QString)), s, SLOT(barcodeAnalysed(QString,QString)));

        }
        //pythonInstances.append(instance);

        /*if(!Shiboken::isShibokenType(instance))
        {
            qDebug() << "Not of Shiboken type!";
            continue;
        }

        //Shiboken::SbkBaseWrapper *wrapper = reinterpret_cast<Shiboken::SbkBaseWrapper*>(instance);
        PythonQTWrapperSink* s = Shiboken::Converter<PythonQTWrapperSink*>::toCpp(instance);*/


//        if ( s ){
//            sinks.append(s);
//            // I guess we'll need to do this for each sink too.
//            connect(parent, SIGNAL(barcodeAnalysedSignal(QString,QString)),
//                    s, SLOT(barcodeAnalysed(QString,QString)));
//        }else
//            continue;

    }

    cout << "PythonQTWrapperPlugin::initInterface() successfully parsed " << QString("%1").arg(sinks.size()).toStdString() << " plugins." << endl;
    Py_DECREF(dict);

}


PythonQTWrapperPlugin::~PythonQTWrapperPlugin(){
    if(this->initialised==true)
        Py_Finalize();
}

QSet<PluginAction*> PythonQTWrapperPlugin::getPluginActions() {
    QSet<PluginAction*> newList;

    // iterate through our sinks
    // insert them all into the list
    foreach(PythonQTWrapperSink *s, sinks)
    {
        qDebug() << "PythonQTWrapperPlugin::getPluginActions() inserting sink " << s->getName();
        newList.insert(s);
    }
    return newList;

    //    QSet<PluginAction*> newList = sinks.toSet(); // instead?
}


QString PythonQTWrapperPlugin::getName()
{
    return "PythonQt wrapper plugin";
};

//QMainWindow* PythonQTWrapperPlugin::getSettingsWindow(QWidget *parent) {
//    return new SettingsWindow(parent, this);
//}

Q_EXPORT_PLUGIN2(mbqt_pythonqtwrapperplugin, PythonQTWrapperPlugin)
