#include <mbarcode-qt/plugininterfaces.h>
#include <mbarcode-qt/pluginaction.h>
#include <mbarcode-qt/maemobarcodewindow.h>

#include "pythonqtwrapperplugin.h"
#include "pythonqtwrappersink.h"
#include <PythonQt.h>

#include <QString>


// initialisation, including setting up the slot hooks between this class and the sink itself
void PythonQTWrapperPlugin::initInterface(QWidget *parent) {

    // this is where we find the Python plugins and ask them what types of barcodes they want.
    // we generate one sink per file, adding into each of the sink classes the appropriate name information
    // as well as the barcode types each wants, and any match !match information they tell us about
    PythonQtObjectPtr mainModule;

    // should this is hardcoded...?
    QDir d("/usr/share/mbarcode/plugins/pythonqt/");
    QStringList filter;
    filter << "*.py";
    QStringList list = d.entryList(filter);


    // we need to init the PythonQt business, but if there are no Python plugins installed, we shoudn't bother as it wastes time and memory
    if (list.size()>0){
        PythonQt::init();
        mainModule = PythonQt::self()->getMainModule();
        if(mainModule.isNull()){
            qDebug() << "Could not get PythonQt mainModule!";
            return;
        }

        mainModule.evalScript(QString("import sys\n"));

    }else
        return; //and make sure we don't get called again

    qDebug() << "PythonQTWrapperPlugin::initInterface() found " << list.size() << " possible plugins.";

    for(int i=0; i<list.size(); ++i)
    {
        QFile f(list.at(i));

        QString filename = d.path().append("/") + f.fileName();
        QString fnName = QString("");

        QString sinkName;
        QString sinkText;
        QImage sinkImage;
        QStringList soughtBarcodeTypes;

        // // create a unique module to hold this plugin
        // PythonQtObjectPtr PythonPluginContext = PythonQt::self()->createUniqueModule();
        // Q_ASSERT(!PythonPluginContext.isNull());

        // // load the Python code, into our module
        // //PythonQt::evalFile(PythonPluginContext, &filename);
        // PythonPluginContext.evalFile(filename);
        // qDebug() << "Loaded plugin " << filename;


        ////PythonQtObjectPtr PythonPluginContext = PythonQt::self()->parseFile(filename);
        ////Q_ASSERT(!PythonPluginContext.isNull());


        mainModule.evalFile(filename);
        qDebug() << "running evalFile(" << filename << ")";

        QString classname(f.fileName());
        classname.chop(3);
        classname.append("()\n");

        qDebug() << "Trying to get Python class instance: " << classname;
        PythonQtObjectPtr PythonPluginContext = mainModule.evalScript(classname, Py_eval_input); // call the class name
        if(PythonPluginContext.isNull()){
            qDebug() << "Failed!";
            continue;
        }

        // the following declarations are the things we will read from each file...

        fnName = "SinkName";
        //sinkName = <QString>PythonQt::call(PythonPluginContext, &fnName);  //, const QVariantList &args = QVariantList());
        sinkName = PythonPluginContext.call(fnName).toString();  //, const QVariantList &args = QVariantList());
        qDebug() << "Plugin returned name " << sinkName;

        // might actually need to convert this from whatever Python throws across!!!
        fnName = "SinkImage";
        sinkImage = PythonPluginContext.call(fnName).value<QImage>();

        fnName = "SinkText";
        //sinkText = <QString>PythonQt::call(PythonPluginContext, &fnName);  //, const QVariantList &args = QVariantList());
        sinkText = PythonPluginContext.call(fnName).toString();  //, const QVariantList &args = QVariantList());
        qDebug() << "Plugin returned text " << sinkText;

        /*fnName = "SoughtBarcodeTypes";
        //soughtBarcodeTypes = <QStringList>PythonQt::call(PythonPluginContext, &fnName);  //, const QVariantList &args = QVariantList());
        soughtBarcodeTypes = PythonPluginContext.call(fnName).toStringList();  //, const QVariantList &args = QVariantList());*/


        // therefore we will need a list to hold multiple sinks here
        PythonQTWrapperSink *s = new PythonQTWrapperSink(this, sinkName, sinkText, sinkImage, PythonPluginContext);

        sinks.append(s);

        // I guess we'll need to do this for each sink too.
        connect(parent, SIGNAL(barcodeAnalysedSignal(QString,QString)),
                s, SLOT(barcodeAnalysed(QString,QString)));
    }

    qDebug() << "PythonQTWrapperPlugin::initInterface() successfully parsed " << sinks.size() << " plugins.";

}

QSet<PluginAction*> PythonQTWrapperPlugin::getPluginActions() {
    QSet<PluginAction*> newList;

    // iterate through our sinks
    // insert them all into the list
    foreach(PythonQTWrapperSink *s, sinks)
    {
        qDebug() << "PythonQTWrapperPlugin::getPluginActions() inserting sink " << s->getName();
        newList.insert(s);
    }
    return newList;

    //    QSet<PluginAction*> newList = sinks.toSet(); // instead?
}


QString PythonQTWrapperPlugin::getName()
{
    return "PythonQt wrapper plugin";
};

//QMainWindow* PythonQTWrapperPlugin::getSettingsWindow(QWidget *parent) {
//    return new SettingsWindow(parent, this);
//}

Q_EXPORT_PLUGIN2(mbqt_pythonqtwrapperplugin, PythonQTWrapperPlugin)
