#include "getopinionsink.h"

#include "getopinionwindow.h"
#include "authenticationwindow.h"
#include "plugin.h"

GetOpinionSink::GetOpinionSink(const PluginInterface *interface) : PluginAction(interface) {
    image = QImage(":/images/logo.png");
    image = image.scaledToHeight(48, Qt::SmoothTransformation);
}

void GetOpinionSink::clickAction(QWidget *parentWindow) {
    if(plugin->authenticated) {
        GetOpinionWindow *getOpWin = new GetOpinionWindow(parentWindow, plugin);
        getOpWin->show();
    } else {
        plugin->checkAuthentication(parentWindow, Plugin::GetOpinion);
    }
}

void GetOpinionSink::setPlugin(Plugin *plugin) {
    this->plugin = plugin;
}

QImage GetOpinionSink::getImage() {
    return image;
}


void GetOpinionSink::emitIsReady() {
    emit isReady();
}
