#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "getopinionwindow.h"
#include "giveopinionwindow.h"
#include "authenticationwindow.h"
#include <QDesktopServices>
#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QDebug>

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    settings = new QSettings("mbarcode","ii-plugin",this);
    //settings->remove("accessToken");
    barcodeData = "12345";
    barcodeType = "EAN";
    consumerKey = "b9wa8eFawRe7e5uXuh";
    consumerSecret = "dECraCRuphAjAxuHEhePr9BajAFet3BR";
    baseUrl = "http://dragly.ath.cx:27020/api/";
    authenticated = false;

    manager = new QNetworkAccessManager(this);
    connect(manager, SIGNAL(finished(QNetworkReply*)),
            this, SLOT(replyFinished(QNetworkReply*)));
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void MainWindow::on_pushButton_clicked()
{
    if(authenticated) {
        qDebug() << settings->value("accessToken","--emtpy--").toByteArray();
        GetOpinionWindow *getOpWin = new GetOpinionWindow(this);
        getOpWin->show();
    } else {
        nextAction = GetOpinion;
        checkAuthentication();
    }
}

void MainWindow::on_pushButton_2_clicked()
{
    if(settings->value("accessToken","--emtpy--").toString() == "--empty--") {
        AuthenticationWindow *authWin = new AuthenticationWindow(this);
        authWin->show();
    } else {
        GiveOpinionWindow *giveOpWin = new GiveOpinionWindow(this, this);
        giveOpWin->show();
    }
}

QString MainWindow::getTimestamp() {
    uint time = QDateTime::currentDateTime().toTime_t();
    return QString::number( time );
}

void MainWindow::checkAuthentication() {
    QString dataUrl = baseUrl + "account/is_authenticated.xml?"; //
    QNetworkRequest request = QNetworkRequest(QUrl(dataUrl + generateOAuthData()));
    manager->get(request);
}

void MainWindow::replyFinished(QNetworkReply* reply) {
    qDebug() << "-- Returned data in MainWindow::replyFinished --";
    qDebug() << reply->readAll();
    if(reply->error() == QNetworkReply::NoError) {
        authenticated = true;
        if(nextAction == GetOpinion) {
            on_pushButton_clicked();
        }
    } else {
        authenticated = false;
        AuthenticationWindow *authWin = new AuthenticationWindow(this);
        authWin->show();
    }
}

QString MainWindow::generateOAuthData() {
    QTime time = QTime::currentTime();
    QString data = "oauth_version=1.0&oauth_nonce=" + time.toString() + QString::number(time.msec()) + "&oauth_timestamp=" + getTimestamp() +
                  "&oauth_consumer_key=" + consumerKey +
                  "&oauth_token=" + settings->value("accessToken","not-defined").toString() +
                  "&oauth_signature_method=PLAINTEXT&oauth_signature=" + consumerSecret + "%26" + settings->value("accessTokenSecret","not-defined").toString();
    return data;
}
