#ifndef AUTHENTICATIONWINDOW_H
#define AUTHENTICATIONWINDOW_H

#include <QMainWindow>
#include <QNetworkAccessManager>

namespace Ui {
    class AuthenticationWindow;
}
class Plugin;
class AuthenticationWindow : public QMainWindow {
    Q_OBJECT
public:
    AuthenticationWindow(QWidget *parent, Plugin *plugin);
    ~AuthenticationWindow();

    enum RequestType {RequestToken, Authorize, AccessToken, ProtectedData};

    bool oAuthRequestToken();
    bool oAuthAuthorizeToken();
    bool oAuthAccessToken();

protected:
    void changeEvent(QEvent *e);

private:

    QString requestToken;
    QString requestTokenSecret;
    QString accessToken;
    QString accessTokenSecret;
    QNetworkAccessManager *manager;
    RequestType requestType;

    QString getTimestamp();

    Plugin *plugin;

    Ui::AuthenticationWindow *ui;

private slots:
    void on_btnVerify_clicked();
    void on_btnOpenBrowser_clicked();
    void replyFinished(QNetworkReply* reply);
};

#endif // AUTHENTICATIONWINDOW_H
