#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QSettings>
#include <QtNetwork>

class GetOpinionWindow;
class GiveOpinionWindow;
class AuthenticationWindow;

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow {
    Q_OBJECT
public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

    enum NextAction {GetOpinion, GiveOpinion};

    QString barcodeType;
    QString barcodeData;
    QSettings *settings;


    QString consumerKey;
    QString consumerSecret;
    QString baseUrl;
    QString getTimestamp();

    QNetworkAccessManager *manager;

    bool authenticated;
    void checkAuthentication();
    NextAction nextAction;
    QString generateOAuthData();
protected:
    void changeEvent(QEvent *e);

private:
    Ui::MainWindow *ui;
private slots:
    void on_pushButton_2_clicked();
    void on_pushButton_clicked();
    void replyFinished(QNetworkReply* reply);
};

#endif // MAINWINDOW_H
