/*
 *  Mauku Widget
 *  Copyright (C) 2009 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as published by
 *  the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MAUKU_WIDGET_H
#define MAUKU_WIDGET_H

#include <libhildondesktop/libhildondesktop.h>

G_BEGIN_DECLS

typedef struct _MaukuWidget MaukuWidget;
typedef struct _MaukuWidgetClass MaukuWidgetClass;
typedef struct _MaukuWidgetPrivate MaukuWidgetPrivate;

#define MAUKU_TYPE_WIDGET (mauku_widget_get_type())
#define MAUKU_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), MAUKU_TYPE_WIDGET, MaukuWidget))
#define MAUKU_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), MAUKU_TYPE_WIDGET, MaukuWidgetClass))
#define MAUKU_IS_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), MAUKU_TYPE_WIDGET))
#define MAUKU_IS_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAUKU_TYPE_WIDGET))
#define MAUKU_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAUKU_TYPE_WIDGET, MaukuWidgetClass))

struct _MaukuWidget {
	HDHomePluginItem parent;
	MaukuWidgetPrivate *priv;
};

struct _MaukuWidgetClass {
	HDHomePluginItemClass parent_class;
};

GType mauku_widget_get_type(void);

G_END_DECLS

#endif
