#include "sudokutablewidget.h"
#include "sudokutable.h"
#include <QPaintEvent>
#include <QPainter>
#include <QMouseEvent>
SudokuTableWidget::SudokuTableWidget()
{
    iSelectedX=0;
    iSelectedY=0;
}
/*
  setTable(CSudokuTable)
  This must be called right after construction, before this class is used.
  */
void SudokuTableWidget::setTable(CSudokuTable *aTable)
{
    iTable = aTable;
}
/*
  mousePressEvent(QMouseEvent)
  Calculate what number player want's to change.
  */
void SudokuTableWidget::mousePressEvent(QMouseEvent * aEvent)
{
    int x = aEvent->pos().x()/(width()/9);
    int y = aEvent->pos().y()/(height()/9);
    if(x<0 || y<0 || x>8 || y>8) {aEvent->ignore();return;}
    iSelectedX=x;
    iSelectedY=y;
    emit slotSelected(x,y);
    repaint();
}
/*
  setSelectedCoordinates(int,int)
  This is used for drawing mark to cell that is being changed.
  */
void  SudokuTableWidget::setSelectedCoordinates(int aX,int aY)
{
    iSelectedX=aX;
    iSelectedY=aY;
}
/*
  paintEvent(QPaintEvent)
  called from repaint()
  */
void SudokuTableWidget::paintEvent(QPaintEvent *aEvent)
{
    int width1 = width();
    int height1 = height();
    int h1=height1/9;
    int w1=width1/9;
    QPainter painter(this);
    painter.setPen(Qt::white);
    for(int j=0;j<9;j++)
    {
        for(int i=0;i<9;i++)
        {
            //Draw mark to cell that is being edited.
            if(i==iSelectedX && j==iSelectedY)
            {
                painter.drawRect(QRect((i*w1)+4, (j*h1)+4, w1-8,  h1-8));
            }
            //set font
            QFont serifFont("Times",h1/2,QFont::Bold);
            painter.setFont(serifFont);
            //Fill nnumbers, but leave zeros to blank.
            if(iTable->getNumL(i,j)!=0)
            {

                painter.drawText(QRect(i*w1+(h1/3),j*h1+(w1/6),w1,h1),QString::number(iTable->getNumL(i,j)));

            }
            else //Draw mwmory numbers
            {
                QFont serifFont("Times",h1/4,QFont::Bold);
                painter.setFont(serifFont);
                if(iTable->isMemoryNumber(1,i,j))
                    painter.drawText(QRect(i*w1+5,j*h1,w1/3,h1/3),QString::number(1));
                if(iTable->isMemoryNumber(2,i,j))
                    painter.drawText(QRect(i*w1+15,j*h1,w1/3,h1/3),QString::number(2));
                if(iTable->isMemoryNumber(3,i,j))
                    painter.drawText(QRect(i*w1+25,j*h1,w1/3,h1/3),QString::number(3));

                if(iTable->isMemoryNumber(4,i,j))
                    painter.drawText(QRect(i*w1+5,j*h1+12,w1/3,h1/3),QString::number(4));
                if(iTable->isMemoryNumber(5,i,j))
                    painter.drawText(QRect(i*w1+15,j*h1+12,w1/3,h1/3),QString::number(5));
                if(iTable->isMemoryNumber(6,i,j))
                    painter.drawText(QRect(i*w1+25,j*h1+12,w1/3,h1/3),QString::number(6));

                if(iTable->isMemoryNumber(7,i,j))
                    painter.drawText(QRect(i*w1+5,j*h1+25,w1/3,h1/3),QString::number(7));
                if(iTable->isMemoryNumber(8,i,j))
                    painter.drawText(QRect(i*w1+15,j*h1+25,w1/3,h1/3),QString::number(8));
                if(iTable->isMemoryNumber(9,i,j))
                    painter.drawText(QRect(i*w1+25,j*h1+25,w1/3,h1/3),QString::number(9));

            }

        }
    }
    //Draw border lines
    if(iTable->isTableFull() && !iTable->isErrorInTableL()) painter.setPen(Qt::green);
    for(int i=0;i<10;i++)
    {
        painter.drawLine(0,i*h1,width1,i*h1);
        painter.drawLine(i*w1,0,i*w1,height1);
        //Draw thiker lines in middle
        if(i==3 || i==6)
        {
            painter.drawLine(0,i*h1+1,width1,i*h1+1);
            painter.drawLine(i*w1+1,0,i*w1+1,height1);
            painter.drawLine(0,i*h1+2,width1,i*h1+2);
            painter.drawLine(i*w1+2,0,i*w1+2,height1);
        }
    }
}
