#include "mainwindow.h"

#include "sudokutable.h"
#include "sudokutablewidget.h"
#include "sudokuselectnumberwidget.h"
#include <QMessageBox>
#include <QHBoxLayout>
#include <QPushButton>
#include <QInputDialog>
#include <QLabel>
#include <QRadioButton>
#include <QMenuBar>


MainWindow::MainWindow(QWidget *parent)

{
    //Create table
    iTable = new CSudokuTable();
    iTable->newGame(20); //unnessesary??
    iTable->clearTable();
    QObject::connect(iTable,SIGNAL(error(QString)),this,SLOT(showError(QString)));

    //Create widget that show table
    iTableWidget = new SudokuTableWidget();
    iTableWidget->setTable(iTable);
    QObject::connect(iTableWidget,SIGNAL(slotSelected(int,int)),this,SLOT(changeNumber(int,int)));

    //Create widget where player can choose number
    iSelectNumberWidget = new SudokuSelectNumberWidget();
    iSelectNumberWidget->setTable(iTable);
    QObject::connect(iSelectNumberWidget,SIGNAL(numberSelected(int)),this,SLOT(repaintElements()));

    //Create widget for laying out other widgets.
    //This is used for Maemo. Normal layout mecamism didn't work.
    iMainWidget = new QWidget();

    iTableWidget->setParent(iMainWidget);
    iTableWidget->setGeometry(10,10,397,397);
    iSelectNumberWidget->setParent(iMainWidget);
    iSelectNumberWidget->setGeometry(595,1,252,252);
    iSelectNumberWidget->setCoordinates(0,0);
    setCentralWidget(iMainWidget);

    //Create buttons
    iSolveOneButton = new QPushButton("Solve one number", this);
    iSolveOneButton->setGeometry(550,360,250,30);
    QObject::connect(iSolveOneButton,SIGNAL(clicked()),this,SLOT(solveOne()));

    //Create label to show Table status to user.
    iSolvableText = new QLabel("...",this);
    iSolvableText->setGeometry(450,395,350,30);

    //Create Radiobuttons
    iNormalNumberRadioButton = new QRadioButton("Normal numbers",this);
    iNormalNumberRadioButton->setGeometry(550,270,350,30);
    iNormalNumberRadioButton->setChecked(true);
    QObject::connect(iNormalNumberRadioButton,SIGNAL(toggled(bool)),this,SLOT(toggleNumberTypes()));
    iMarkupNumberRadioButton = new QRadioButton("Markup numbers",this);
    iMarkupNumberRadioButton->setGeometry(550,310,350,30);
    QObject::connect(iMarkupNumberRadioButton,SIGNAL(toggled(bool)),this,SLOT(toggleNumberTypes()));


    //Create Menu
    QAction *newGameAction = new QAction("New Game",this);
    QObject::connect(newGameAction,SIGNAL(triggered()),this,SLOT(newGame()));    
    QAction *practiseAction = new QAction("Practice mode",this);
    QObject::connect(practiseAction ,SIGNAL(triggered()),this,SLOT(changeSettings()));
    QAction *solveTableAction = new QAction("Solve table",this);
    QObject::connect(solveTableAction,SIGNAL(triggered()),this,SLOT(solveTable()));
    QAction *checkTableAction = new QAction("Check table",this);
    QObject::connect(checkTableAction,SIGNAL(triggered()),this,SLOT(checkTable()));
    QAction *abouttAction = new QAction("About",this);
    QObject::connect(abouttAction,SIGNAL(triggered()),this,SLOT(aboutt()));
    menuBar()->addAction(newGameAction);
    menuBar()->addAction(practiseAction);
    menuBar()->addAction(solveTableAction);
    menuBar()->addAction(checkTableAction);
    menuBar()->addAction(abouttAction);

    //Init other member atributes
    iCriticalError=false;
    iSettingAutoCheck=false;
    iSelectNumberWidget->setSettingNumberHints(false);
}
MainWindow::~MainWindow()
{
    delete iTable;
}
void MainWindow::aboutt()
{
        QMessageBox::information(this,"About","Petri Kultanen <pete@petnetti.net>");
}
void MainWindow::checkTable()
{
    if(iTable->isTableSolvableL())
    {
        QMessageBox::information(this,"OK","Table is solvable.");
    }
    else
    {
        QMessageBox::critical(this,"Error","Table is not solvable.");
    }
}

/*
  changeSettings()
  called from menu item "practice mode"
  */
void MainWindow::changeSettings()
{
    if(iSettingAutoCheck)
    {
        iSettingAutoCheck=false;
        iSelectNumberWidget->setSettingNumberHints(false);
    }
    else
    {
        iSettingAutoCheck=true;
        iSelectNumberWidget->setSettingNumberHints(true);

    }
    repaintElements();

}
/*
  solveOne()
  Try solve one number from table.
  Called from Button press.
  */
void MainWindow::solveOne()
{    

    if( iTable->fillOneNumberL())
    {
        repaintElements();
    }
    else
    {
        if(iTable->isTableFull())
            QMessageBox::information(this,"Info","Table is already full!.");
        else
            QMessageBox::critical(this,"Error","Table not solvable, can't add number.");
    }

}
/*
  solveTable()
  Try solve whole table
  Called from Button press.
  */
void MainWindow::solveTable()
{
    if(iTable->isTableSolvableL())
    {
        iTable->fillWholeTableL();
        repaintElements();
    }
    else
    {
        QMessageBox::critical(this,"Error","Table not solvable.");
    }    
}
/*
  newGame()
  Start new game, and ask difficulty and other settings from user
  called from menu
  */
void MainWindow::newGame()
{
    QStringList list;    
    list.append("Easy");
    list.append("Medium");
    list.append("Hard");
    //list.append("Impossible");
    list.append("Empty");
    bool ok;
    QString item = QInputDialog::getItem(this,"New Game","Select Dificulty",list,0,false,&ok);
    if(ok)
    {

        if(item.contains("Easy")) {iTable->newGame(20);}
        if(item.contains("Medium")) {iTable->newGame(40);}
        if(item.contains("Hard")) {iTable->newGame(51);}
        //  if(item.contains("Impossible")) {iTable->newGame(52);}
        if(item.contains("Empty")) {iTable->clearTable();}
        iTableWidget->setSelectedCoordinates(0,0);
        iSelectNumberWidget->setCoordinates(0,0);
    }
    repaintElements();
}
/*
  showError(QString)
  Handle errors from iTable.
  Show error code and exit application.
  */
void MainWindow::showError(QString aString)
{
    //Because this is called with signals, there may be more than one call to this funktion.
    //So we use iCritical error to chek that this is called only once before aplication closes.
    if(!iCriticalError)
    {
        iCriticalError=true;
        QMessageBox::critical(this, tr("Critical Message... Application closing... "),
                              aString,
                              QMessageBox::Ok );
        exit(0);
    }
}
/*
  changeNumber(int,int)
  Called from SudokuTableWidget, when mouse pressed.
  */
void  MainWindow::changeNumber(int aX,int aY)
{

    iSelectNumberWidget->setCoordinates(aX,aY);
}
/*
  repaintElements()
  Update screen
  */
void  MainWindow::repaintElements()
{
    if(iSettingAutoCheck)
    {
        if(iTable->isTableSolvableL())
        {
            iSolvableText->setText("Practice mode: Table is ok");
        }
        if(iTable->isErrorInTableL())
        {
            iSolvableText->setText("Practice mode: There are errors.");
        }
        else{
            if(iTable->isTableSolvableL()==false)
            {
                iSolvableText->setText("Practice mode: Can't solve table");
            }
        }
    }
    else
    {
        iSolvableText->setText("Practice mode: OFF");
    }
    if(iTable->isTableFull() && !iTable->isErrorInTableL() )
    {
        iSolvableText->setText("Table is finished !!!");
    }
    iMainWidget->repaint();
    iSelectNumberWidget->repaint();
}

void MainWindow::toggleNumberTypes()
{
    if (iNormalNumberRadioButton->isChecked())   iSelectNumberWidget->setSettingMarkupOrNormalNumbers(ENormalNumbers);
    else   iSelectNumberWidget->setSettingMarkupOrNormalNumbers(EMarkupNumbers);

    repaintElements();
}
