/*
 * This file is part of mapper
 *
 * Copyright (C) 2007 Kaj-Michael Lang
 * Copyright (C) 2006-2007 John Costigan.
 *
 * POI and GPS-Info code originally written by Cezary Jackiewicz.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "config.h"

#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <stddef.h>
#include <errno.h>
#include <sys/wait.h>
#include <glib/gstdio.h>
#include <gtk/gtk.h>
#include <fcntl.h>
#include <libintl.h>
#include <locale.h>

#include "utils.h"
#include "mapper-types.h"
#include "dialogs.h"
#include "gps-scan.h"

/**
 * Scan for all bluetooth devices.  This method can take a few seconds,
 * during which the UI will freeze.
 */
gboolean
gps_scan_bluetooth(GtkWidget *widget, GpsScanInfo *scan_info)
{
GError *error=NULL;
GtkWidget *dialog, *sw;
GtkWidget *devices;
GtkTreeViewColumn *column;
GtkCellRenderer *renderer;

dialog=gtk_dialog_new_with_buttons(_("Select Bluetooth Device"),
	GTK_WINDOW(scan_info->window), GTK_DIALOG_MODAL,
	GTK_STOCK_OK, GTK_RESPONSE_ACCEPT,
	GTK_STOCK_CANCEL, GTK_RESPONSE_REJECT,
	NULL);
gtk_window_set_default_size(GTK_WINDOW(dialog), 500, 300);

scan_info->dialog=dialog;
scan_info->store=gtk_list_store_new(2, G_TYPE_STRING, G_TYPE_STRING);

#ifndef WITH_HILDON_2_2
sw=gtk_scrolled_window_new(NULL, NULL);
gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sw), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
devices=gtk_tree_view_new();
#else
sw=hildon_pannable_area_new();
devices=hildon_gtk_tree_view_new(HILDON_UI_MODE_EDIT);
#endif
gtk_container_add(GTK_CONTAINER(sw), devices);
gtk_tree_view_set_model(devices, GTK_TREE_MODEL(scan_info->store));

gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), sw, TRUE, TRUE, 0);

g_object_unref(G_OBJECT(scan_info->store));

gtk_tree_selection_set_mode(gtk_tree_view_get_selection(GTK_TREE_VIEW(devices)), GTK_SELECTION_SINGLE);
gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(devices), TRUE);

renderer=gtk_cell_renderer_text_new();
column=gtk_tree_view_column_new_with_attributes(_("MAC"), renderer, "text", 0, NULL);
gtk_tree_view_append_column(GTK_TREE_VIEW(devices), column);

renderer=gtk_cell_renderer_text_new();
column=gtk_tree_view_column_new_with_attributes(_("Description"), renderer, "text", 1, NULL);
gtk_tree_view_append_column(GTK_TREE_VIEW(devices), column);
gtk_widget_show_all(dialog);
scan_info->banner=hildon_banner_show_animation(dialog, NULL, _("Scanning for Bluetooth Devices"));

if (gps_scan_start_search(scan_info)) {
	gtk_widget_destroy(scan_info->banner);
	popup_error(scan_info->dialog, _("An error occurred while attempting to scan for bluetooth devices."));
} else
	while (GTK_RESPONSE_ACCEPT==gtk_dialog_run(GTK_DIALOG(dialog))) {
		GtkTreeIter iter;
		if (gtk_tree_selection_get_selected(gtk_tree_view_get_selection(GTK_TREE_VIEW(devices)), NULL, &iter)) {
			gchar *mac;

			gtk_tree_model_get(GTK_TREE_MODEL(scan_info->store), &iter, 0, &mac, -1);
			gtk_entry_set_text(GTK_ENTRY(scan_info->txt_rcvr_mac), mac);
			break;
		} else
			popup_error(dialog, _("Please select a bluetooth device from the list."));
	}

gps_scan_stop_search(scan_info);
gtk_widget_destroy(dialog);

return TRUE;
}
