/*
 * This file is part of mapper
 *
 * Copyright (C) 2007 Kaj-Michael Lang
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "config.h"

#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <stddef.h>
#include <glib/gstdio.h>
#include <gtk/gtk.h>
#include <libintl.h>
#include <locale.h>

#include "hildon-mapper.h"

#include "utils.h"
#include "gps.h"
#include "map.h"
#include "mapper-types.h"
#include "ui-common.h"
#include "settings.h"
#include "filter.h"
#include "filter-gui.h"
#include "config-gconf.h"

gboolean
filter_dialog(GtkWidget *window)
{
GtkWidget *dialog;
GtkWidget *table;
GtkWidget *notebook;
GtkWidget *label;

GtkWidget *chk_gps_filter;
GtkWidget *num_angle;
GtkWidget *num_hdop;
GtkWidget *num_vdop;
GtkWidget *num_osm_dist;
GtkWidget *num_maxdrop;

dialog = gtk_dialog_new_with_buttons(_("Track Filter"),
				GTK_WINDOW(window),
				GTK_DIALOG_MODAL, GTK_STOCK_OK, GTK_RESPONSE_ACCEPT, 
				GTK_STOCK_CANCEL, GTK_RESPONSE_REJECT, NULL);

gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), notebook = gtk_notebook_new(), TRUE, TRUE, 0);

gtk_notebook_append_page(GTK_NOTEBOOK(notebook), table = gtk_table_new(2,4,FALSE), label = gtk_label_new(_("GPS")));

gtk_table_attach(GTK_TABLE(table), chk_gps_filter = gtk_check_button_new_with_label(_("Enable track filter")),
		 0, 2, 0, 1, GTK_EXPAND | GTK_FILL, 0, 2, 4);
gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_gps_filter), filter.enabled);

gtk_table_attach(GTK_TABLE(table), label = gtk_label_new(_("Horizontal DOP limit")), 0, 1, 1, 2, GTK_FILL, 0, 2, 4);
gtk_misc_set_alignment(GTK_MISC(label), 1.f, 0.5f);
gtk_table_attach(GTK_TABLE(table), num_hdop = gtk_hscale_new_with_range(0, 200, 0.1), 1, 2, 1, 2, GTK_EXPAND | GTK_FILL, 0, 2, 4);

gtk_table_attach(GTK_TABLE(table), label = gtk_label_new(_("Vertical DOP limit")), 0, 1, 2, 3, GTK_FILL, 0, 2, 4);
gtk_misc_set_alignment(GTK_MISC(label), 1.f, 0.5f);
gtk_table_attach(GTK_TABLE(table), num_vdop = gtk_hscale_new_with_range(0, 200, 0.1), 1, 2, 2, 3, GTK_EXPAND | GTK_FILL, 0, 2, 4);

gtk_table_attach(GTK_TABLE(table), label = gtk_label_new(_("Minimum Angle change")), 0, 1, 3, 4, GTK_FILL, 0, 2, 4);
gtk_misc_set_alignment(GTK_MISC(label), 1.f, 0.5f);
gtk_table_attach(GTK_TABLE(table), num_angle = gtk_hscale_new_with_range(0, 45, 0.5), 1, 2, 3, 4, GTK_EXPAND | GTK_FILL, 0, 2, 4);

gtk_notebook_append_page(GTK_NOTEBOOK(notebook), table = gtk_table_new(2,1,FALSE), label = gtk_label_new(_("Other")));

/* Distance to OSM data */
gtk_table_attach(GTK_TABLE(table), label = gtk_label_new(_("Distance to OSM Data")), 0, 1, 0, 1, GTK_FILL, 0, 2, 4);
gtk_misc_set_alignment(GTK_MISC(label), 1.f, 0.5f);
gtk_table_attach(GTK_TABLE(table), num_osm_dist = gtk_hscale_new_with_range(0, 5000, 50), 1, 2, 0, 1, GTK_EXPAND | GTK_FILL, 0, 2, 4);

gtk_table_attach(GTK_TABLE(table), label = gtk_label_new(_("Track point drop limit. 0=drop until valid.")), 0, 1, 2, 3, GTK_FILL, 0, 2, 4);
gtk_misc_set_alignment(GTK_MISC(label), 1.f, 0.5f);
gtk_table_attach(GTK_TABLE(table), num_maxdrop = gtk_hscale_new_with_range(0, 60, 1), 1, 2, 2, 3, GTK_EXPAND | GTK_FILL, 0, 2, 4);

gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_gps_filter), filter.enabled);
gtk_range_set_value(GTK_RANGE(num_hdop), filter.hdop);
gtk_range_set_value(GTK_RANGE(num_vdop), filter.vdop);
gtk_range_set_value(GTK_RANGE(num_angle), filter.angle);
gtk_range_set_value(GTK_RANGE(num_osm_dist), filter.osm);
gtk_range_set_value(GTK_RANGE(num_maxdrop), filter.maxdrop);

gtk_window_set_default_size(GTK_WINDOW(dialog), 500, 300);
gtk_widget_show_all(dialog);

if (GTK_RESPONSE_ACCEPT == gtk_dialog_run(GTK_DIALOG(dialog))) {
	filter.angle=gtk_range_get_value(GTK_RANGE(num_angle));
	filter.hdop=gtk_range_get_value(GTK_RANGE(num_hdop));
	filter.vdop=gtk_range_get_value(GTK_RANGE(num_vdop));
	filter.osm=gtk_range_get_value(GTK_RANGE(num_osm_dist));
	filter.maxdrop=gtk_range_get_value(GTK_RANGE(num_maxdrop));
	filter.enabled=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chk_gps_filter));

	config_save_filter(&filter);
}

gtk_widget_destroy(dialog);

return TRUE;
}
