/*
 * This file is part of mapper
 *
 * Copyright (C) 2007 Kaj-Michael Lang
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <glib.h>
#include <sqlite3.h>

#ifndef _MAPPER_DB_H
#define _MAPPER_DB_H

#define DB_PREP(db_,sql_,stmt_) \
	if (sqlite3_prepare_v2(db_, sql_, -1, &stmt_, NULL)!=SQLITE_OK) { \
		g_warning("Failed to prepare: [%s] Error: %s", sql_, sqlite3_errmsg(db_)); \
		stmt_=NULL; \
		db_close(&db_); \
		return FALSE; \
	}

#define DB_FINALIZE(db_,stmt_) \
	if (stmt_) { \
		if (sqlite3_finalize(stmt_)!=SQLITE_OK) { \
			g_warning("Failed to finalize statement, error: %s", sqlite3_errmsg(db_)); \
		} else { stmt_=NULL; } \
	}

#define DB_ERROR(db_) g_warning("SQL Error: %s", sqlite3_errmsg(db_));

sqlite3 *_db;
gchar *_mapper_db;

gboolean db_connect(sqlite3 **db, const gchar *mapper_db);
gboolean db_check(sqlite3 *db, const gchar *table);
gboolean db_close(sqlite3 **db);
gboolean db_exec_sql(sqlite3 *db, const gchar *sql);
gboolean db_exec(sqlite3 *db, sqlite3_stmt *sql);
gboolean db_exec_sql_array(sqlite3 *db, const gchar **sql);

gboolean db_transaction_begin(sqlite3 *db);
gboolean db_transaction_commit(sqlite3 *db);

#endif
