#ifndef _MAPPER_UI_COMMON_H
#define _MAPPER_UI_COMMON_H

#include "config.h"

#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <stddef.h>
#include <locale.h>
#include <math.h>
#include <errno.h>
#include <sys/wait.h>
#include <glib/gstdio.h>
#include <gtk/gtk.h>
#include <fcntl.h>

#include <dicto/dicto.h>
#include <dicto/dicto-ui.h>

#include "gps.h"
#include "mapper-types.h"
#include "hildon-wrappers.h"

#define SCALE_WIDTH (200)

typedef struct _MapperUiInfoBanner MapperUiInfoBanner;
struct _MapperUiInfoBanner {
	GtkWidget *container;
	GtkWidget *op;
	GtkWidget *ope;

	GtkWidget *location_ref;
	GtkWidget *location_intref;
	GtkWidget *location_name;

	GtkWidget *time;
	GtkWidget *speed;
	GtkWidget *distance;
};

typedef struct _MapperUi MapperUi;
struct _MapperUi {
	/* Main application UI items */
	GtkWidget *mainwindow;
	GtkWidget *maincontainer;
	GtkWidget *menu_bar;
	GtkWidget *toolbar;
	GtkWidget *progress;

	/* Banners/Progress bars */
	GtkWidget *status_bar;

	/* UI and Action groups */
	GtkUIManager *ui;
	GtkActionGroup *actions;
	GtkActionGroup *repo_actions;

	MapperUiInfoBanner ib;

	/* Notebook interface */
	GtkNotebook *nb;
	gint nb_map;
	gint nb_gps;
	gint nb_heading;
	gint nb_route;
	gint nb_track;
	gint nb_qpoi;
	gint nb_audio;

	GtkWidget *map_widget;

	/** The main GtkContainer of the application. */
	GtkWidget *gps_widget;

	/* GPS Tab widget */
	GtkWidget *gps_sat_view;

	/* Heading Tab widget */
	GtkWidget *tab_compass;

	/* */
	GtkWidget *route_sidebar;
	GtkWidget *route_tree_view;

	/* */
	GtkWidget *track_sidebar;
	GtkWidget *track_tree_view;

	/* Audio interface */
	GtkWidget *audio_ui;
};

MapperUi mapp;

GtkWidget *_sdi_lat;
GtkWidget *_sdi_lon;
GtkWidget *_sdi_spd;
GtkWidget *_sdi_alt;
GtkWidget *_sdi_hea;
GtkWidget *_sdi_tim;
GtkWidget *_sdi_vie;
GtkWidget *_sdi_use;
GtkWidget *_sdi_fix;
GtkWidget *_sdi_fqu;
GtkWidget *_sdi_msp;

/** Pango stuff. */
PangoContext *_sat_panel_context;
PangoLayout *_sat_panel_layout;
PangoFontDescription *_sat_panel_fontdesc;
GdkGC *_sat_info_gc1;
GdkGC *_sat_info_gc2;
PangoContext *_sat_info_context;
PangoLayout *_sat_info_layout;
PangoFontDescription *_sat_info_fontdesc;

/** THE GdkGC OBJECTS USED FOR DRAWING. */
GdkGC *_gc[COLORABLE_ENUM_COUNT];
GdkColor _color[COLORABLE_ENUM_COUNT];

/* Menu items for the "Location" context menu. */
GtkWidget *_cmenu_loc_show_latlon_item;
GtkWidget *_cmenu_loc_clip_latlon_item;
GtkWidget *_cmenu_loc_route_to_item;
GtkWidget *_cmenu_loc_distance_to_item;
GtkWidget *_cmenu_loc_add_route;
GtkWidget *_cmenu_loc_add_way;
GtkWidget *_cmenu_loc_set_gps;
GtkWidget *_cmenu_loc_set_destination;
GtkWidget *_cmenu_loc_set_home;

/* Menu items for the "Waypoint" context menu. */
GtkWidget *_cmenu_way_show_latlon_item;
GtkWidget *_cmenu_way_show_desc_item;
GtkWidget *_cmenu_way_clip_latlon_item;
GtkWidget *_cmenu_way_clip_desc_item;
GtkWidget *_cmenu_way_route_to_item;
GtkWidget *_cmenu_way_distance_to_item;
GtkWidget *_cmenu_way_delete_item;
GtkWidget *_cmenu_way_add_poi;
GtkWidget *_cmenu_way_goto_nextway;

/* Menu items for the "POI" context menu. */
GtkWidget *_menu_poi;
GtkWidget *_cmenu_poi;
GtkWidget *_cmenu_poi_info;
GtkWidget *_cmenu_poi_edit_poi;
GtkWidget *_cmenu_poi_route_to_item;
GtkWidget *_cmenu_poi_distance_to_item;
GtkWidget *_cmenu_loc_add_poi;
GtkWidget *_cmenu_poi_add_route;
GtkWidget *_cmenu_poi_add_way;
GtkWidget *_cmenu_poi_goto_nearpoi;

GtkMenu *_menu_map;

/** Context menu click location on map */
guint _cmenu_position_x;
guint _cmenu_position_y;

GtkWidget *mapper_window_new(void);
MapperUi *mapper_ui_init(GtkWidget *mw);
gboolean mapper_window_present(void);

void set_action_sensitive(const char *name, gboolean sensitive);
void set_action_activate(const char *name, gboolean active);

/* XXX: Not the right place but.. */
gboolean gps_info_update(Gps *gps);
gboolean gps_retry_connection(Gps *gps, const gchar *error);

#endif
