#define CONFIG_DIR_NAME "~/.mapper/"
#define CONFIG_FILE_ROUTE "route.gpx"
#define CONFIG_FILE_TRACK "track.gpx"

#define GCONF_KEY_PREFIX "/apps/maemo/mapper"

#define REPO_DEFAULT_NAME "OpenStreetMap"
#ifdef WITH_DEVICE_MAEMO
#define REPO_DEFAULT_CACHE_BASE "~/MyDocs/.maps/"
#else
#define REPO_DEFAULT_CACHE_BASE "~/Maps/"
#endif
#define REPO_DEFAULT_CACHE_DIR REPO_DEFAULT_CACHE_BASE"OpenStreetMap"
#define REPO_DEFAULT_MAP_URI "http://tile.openstreetmap.org/%0d/%d/%d.png"
#define REPO_DEFAULT_DL_ZOOM_STEPS (1)
#define REPO_DEFAULT_VIEW_ZOOM_STEPS (1)

#define ROUTE_DOWNLOAD_URL "http://routes.cloudmade.com/0719e0327cf8597c8080ca549969c935/api/0.3/%s,%s/car.gpx?lang=en&units=km"

/* GPS */
#define GCONF_KEY_GPS_TYPE GCONF_KEY_PREFIX"/receiver_type"
#define GCONF_KEY_GPS_MAC GCONF_KEY_PREFIX"/receiver_mac"
#define GCONF_KEY_GPS_PORT GCONF_KEY_PREFIX"/receiver_port"
#define GCONF_KEY_GPS_CHAN GCONF_KEY_PREFIX"/receiver_channel"
#define GCONF_KEY_ENABLE_GPS GCONF_KEY_PREFIX"/enable_gps"

/* Track filtering */
#define GCONF_KEY_GPS_FILTER GCONF_KEY_PREFIX"/gps_filter"
#define GCONF_KEY_GPS_FILTER_HDOP GCONF_KEY_PREFIX"/gps_filter_hdop"
#define GCONF_KEY_GPS_FILTER_VDOP GCONF_KEY_PREFIX"/gps_filter_vdop"
#define GCONF_KEY_GPS_FILTER_ANGLE GCONF_KEY_PREFIX"/gps_filter_angle"
#define GCONF_KEY_GPS_FILTER_OSM GCONF_KEY_PREFIX"/gps_filter_osm"
#define GCONF_KEY_GPS_FILTER_MAXDROP GCONF_KEY_PREFIX"/gps_filter_maxdrop"

/* Misc */
#define GCONF_KEY_MAP_URI_FORMAT GCONF_KEY_PREFIX"/map_uri_format"
#define GCONF_KEY_MAP_ZOOM_STEPS GCONF_KEY_PREFIX"/map_zoom_steps"
#define GCONF_KEY_MAP_DIR_NAME GCONF_KEY_PREFIX"/map_cache_dir"
#define GCONF_KEY_AUTO_DOWNLOAD GCONF_KEY_PREFIX"/auto_download"
#define GCONF_KEY_REPOSITORIES GCONF_KEY_PREFIX"/repositories"
#define GCONF_KEY_CURRREPO GCONF_KEY_PREFIX"/curr_repo"
#define GCONF_KEY_CENTER_SENSITIVITY GCONF_KEY_PREFIX"/center_sensitivity"

#define GCONF_KEY_DRAW_WIDTH GCONF_KEY_PREFIX"/draw_width"
#define GCONF_KEY_INFO_FONT_SIZE GCONF_KEY_PREFIX"/info_font_size"

/* Voice */
#define GCONF_KEY_ENABLE_VOICE GCONF_KEY_PREFIX"/enable_voice"
#define GCONF_KEY_VOICE_SPEED GCONF_KEY_PREFIX"/voice_speed"
#define GCONF_KEY_VOICE_PITCH GCONF_KEY_PREFIX"/voice_pitch"
#define GCONF_KEY_ANNOUNCE_NOTICE GCONF_KEY_PREFIX"/announce_notice"

#define GCONF_KEY_ANNOUNCE_WAYPOINTS GCONF_KEY_PREFIX"/announce_waypoints"
#define GCONF_KEY_ANNOUNCE_OVERSPEED GCONF_KEY_PREFIX"/announce_overspeed"
#define GCONF_KEY_ANNOUNCE_DESTINATION GCONF_KEY_PREFIX"/announce_destination"

#define GCONF_KEY_ALWAYS_KEEP_ON GCONF_KEY_PREFIX"/always_keep_on"
#define GCONF_KEY_UNITS GCONF_KEY_PREFIX"/units"

/* Speed display */
#define GCONF_KEY_SPEED_LIMIT_ON GCONF_KEY_PREFIX"/speed_limit_on"
#define GCONF_KEY_SPEED_LIMIT GCONF_KEY_PREFIX"/speed_limit"
#define GCONF_KEY_SPEED_LOCATION GCONF_KEY_PREFIX"/speed_location"

/* Database */
#define GCONF_KEY_MAPPER_DB GCONF_KEY_PREFIX"/mapper_db"

/* POI */
#define GCONF_KEY_POI_ZOOM GCONF_KEY_PREFIX"/poi_zoom"
#define GCONF_KEY_POI_THEME_BASE GCONF_KEY_PREFIX"/poi_theme_base"
#define GCONF_KEY_POI_ICON_THEME GCONF_KEY_PREFIX"/poi_icon_theme"

#define GCONF_KEY_AUTOCENTER_MODE GCONF_KEY_PREFIX"/autocenter_mode"
#define GCONF_KEY_LEAD_AMOUNT GCONF_KEY_PREFIX"/lead_amount"
#define GCONF_KEY_ZOOM GCONF_KEY_PREFIX"/zoom"

#define GCONF_KEY_POSITION_GPS GCONF_KEY_PREFIX"/gps_latlon"
#define GCONF_KEY_POSITION_CENTER GCONF_KEY_PREFIX"/center_latlon"
#define GCONF_KEY_POSITION_HOME GCONF_KEY_PREFIX"/home_latlon"
#define GCONF_KEY_POSITION_DEST GCONF_KEY_PREFIX"/destination_latlon"

/* Display features */
#define GCONF_KEY_SHOWSCALE GCONF_KEY_PREFIX"/show_scale"
#define GCONF_KEY_SHOWTRACKS GCONF_KEY_PREFIX"/show_tracks"
#define GCONF_KEY_SHOWROUTES GCONF_KEY_PREFIX"/show_routes"
#define GCONF_KEY_SHOWVELVEC GCONF_KEY_PREFIX"/show_velocity_vector"
#define GCONF_KEY_SHOWPOIS GCONF_KEY_PREFIX"/show_poi"

/* Route */
#define GCONF_KEY_ROUTE_LOCATIONS GCONF_KEY_PREFIX"/route_locations"
#define GCONF_KEY_ROUTEDIR GCONF_KEY_PREFIX"/route_directory"
#define GCONF_KEY_ROUTE_DL_URL GCONF_KEY_PREFIX"/route_dl_url"
#define GCONF_KEY_ROUTE_DL_RADIUS GCONF_KEY_PREFIX"/route_dl_radius"

#define GCONF_KEY_TRACK_DL_RADIUS GCONF_KEY_PREFIX"/track_dl_radius"
#define GCONF_KEY_TRACKFILE GCONF_KEY_PREFIX"/track_file"
#define GCONF_KEY_DEG_FORMAT GCONF_KEY_PREFIX"/deg_format"

/* Proxy */
#define GCONF_KEY_HTTP_PROXY_PREFIX "/system/http_proxy"
#define GCONF_KEY_HTTP_PROXY_ON GCONF_KEY_HTTP_PROXY_PREFIX"/use_http_proxy"
#define GCONF_KEY_HTTP_PROXY_HOST GCONF_KEY_HTTP_PROXY_PREFIX"/host"
#define GCONF_KEY_HTTP_PROXY_PORT GCONF_KEY_HTTP_PROXY_PREFIX"/port"

/* Interface */
#define GCONF_KEY_UI_TOOLBAR GCONF_KEY_PREFIX"/ui_show_toolbar"
#define GCONF_KEY_UI_FULLSCREEN GCONF_KEY_PREFIX"/ui_fullscreen"

/* OSSO/IAP specific */
#define GCONF_KEY_DISCONNECT_ON_COVER "/system/osso/connectivity/IAP/disconnect_on_cover"
