#ifndef _OSM_DB_IMPORT_H
#define _OSM_DB_IMPORT_H

#include <glib.h>

#include "osm.h"

/* POI or Place node extra data */
typedef struct _node_data node_data;
struct _node_data {
	gchar *name;
	gchar *desc;
	gchar *url;
	gchar *postal_code;
	guint32 isin_c;
	guint32 isin_p;
};

/* Node type */
typedef struct _node node;
struct _node {
	guint32 id;
	gdouble lat;
	gdouble lon;
	node_type_t type;
	node_data *data;
};

/* Way data structure */
typedef struct _way_data way_data;
struct _way_data {
	gchar *name;
	GHashTable *names;
	gchar *ref;
	gchar *int_ref;
	gchar *postal_code;
	guint32 isin_c; /* Country */
	guint32 isin_p; /* Primary (city, village) place */
	guint speed;
	gint8 layer;
};

/* Way structure */
typedef struct _way way;
struct _way {
	guint32 id;
	way_type_t type;
	guint16 ncnt;
	guint16 flags;
	way_data *data;
	GSList *nodes;
};

struct map_bbox {
	gdouble lat_min;
	gdouble lon_min;
	gdouble lat_max;
	gdouble lon_max;
};

/* Struct with import request */
typedef struct _osm_import_data_req osm_import_data_req;
struct _osm_import_data_req {
	gchar *planet;
	gchar *db;
	GSourceFunc progress_cb;
	GSourceFunc done_cb;
};

void osm_import_set_bbox(gboolean use_bb, gdouble latmin, gdouble lonmin, gdouble latmax, gdouble lonmax);
gboolean osm_import(const gchar *planet, const gchar *database);
gboolean osm_import_bg(const gchar *planet, const gchar *database, GSourceFunc progress_cb, GSourceFunc done_cb);
gint osm_import_join_bg(void);

#endif
