/*
 * This file is part of mapper
 *
 * Copyright (C) 2007 Kaj-Michael Lang
 *
 * POI and GPS-Info code originally written by Cezary Jackiewicz.
 *
 * Default map data provided by http://www.openstreetmap.org/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#ifndef _MAPPER_MAP_POI_H
#define _MAPPER_MAP_POI_H

gboolean map_poi_init(GtkWidget *map_widget);
void map_poi_deinit(void);

void map_render_poi(void);
void map_render_all_pois(guint width, guint height);
void map_poi_cache_clear(void);
gboolean map_poi_find_at_latlon(gdouble lat, gdouble lon, guint *poi_id);
gboolean map_poi_find_at_map_xy(gint x, gint y, gint range, guint *poi_id);

#endif
