#ifndef _OSM_SQL_TABLES
#define _OSM_SQL_TABLES


/**
 * SQL Table and index definitions
 *
 */

#define OSM_TABLE_NODES "create table IF NOT EXISTS nodes ( \
	nid	int primary key, \
	ilat	int not null, \
	ilon	int not null, \
	l	int, \
	f	int);"

#define OSM_TABLE_NODE_TAGS "create table IF NOT EXISTS node_tags ( \
	nid	int not null, t text);"

#define OSM_TABLE_WAY "create table IF NOT EXISTS way ( \
	wid	int primary key, \
	type	int not null, \
	nodes	int not null, \
	flags	int, \
	speed	int, \
	isin_c	int, \
	isin_p	int, \
	lat	real not null, \
	lon	real not null);"

#define OSM_TABLE_WAY_TAGS "create table IF NOT EXISTS way_tags ( \
	wid int not null, \
	t text);"

#define OSM_TABLE_WAY_UPDATES "create table IF NOT EXISTS way_updates ( \
	wid	int primary key, \
	utime	int not null, \
	notes	text);"

#define OSM_TABLE_WAY_N2N "create table IF NOT EXISTS way_n2n ( \
	wid	int not null, \
	f	int not null, \
	t	int not null);"

#define OSM_TABLE_WAY_NAMES "create table IF NOT EXISTS way_names ( \
	wid	int primary key, \
	name	varchar(256));"

#define OSM_TABLE_WAY_PC "create table IF NOT EXISTS way_pc ( \
	wid	int primary key, \
	pc	varchar(256));"

#define OSM_TABLE_WAY_NAMES_NLS "create table IF NOT EXISTS way_names_nls ( \
	wid	int not null, \
	lang	char(4) not null, \
	name	varchar(256));"

#define OSM_TABLE_WAY_REF "create table IF NOT EXISTS way_ref ( \
	rid	int primary key, \
	ref	varchar(32), \
	int_ref	varchar(32));"

#define OSM_TABLE_PLACES "create table IF NOT EXISTS places ( \
	nid	int primary key, \
	type	int not null, \
	name	text, \
	isin_p	int not null, \
	isin_c	int not null, \
	lat	real not null, \
	lon	real not null);"

#define OSM_TABLE_POI "create table IF NOT EXISTS poi ( \
	poi_id	INTEGER PRIMARY KEY AUTOINCREMENT, \
	lat	real not null, \
	lon	real not null, \
	elev	real, \
	label	text, \
	desc	text, \
	url	text, \
	postal_code text, \
	public	int default 1, \
	source	int default 0, \
	cat_id	int, \
	osm_id	int, \
	isin_p	int, \
	isin_c	int, \
	priority int default 2, \
	addtime	int);"

#define OSM_TABLE_POI_CATEGORY "create table IF NOT EXISTS category ( \
	cat_id		INTEGER PRIMARY KEY AUTOINCREMENT, \
	pcat_id		int not null default 0, \
	priority	int not null default 2, \
	label		text, \
	desc		text, \
	color		char(6) not null default '#AAAA40', \
	icon		varchar(32), \
	enabled		int not null default 1);"

/* Indexes */
#define OSM_INDEX_1 "CREATE UNIQUE INDEX IF NOT EXISTS poi_lat_lon_idx on poi (lat, lon, cat_id);"
#define OSM_INDEX_2 "CREATE INDEX IF NOT EXISTS poi_priority on poi (priority);"

/* Node indexes */
#define OSM_INDEX_3 "CREATE INDEX IF NOT EXISTS node_rlat_idx on nodes (rlat);"
#define OSM_INDEX_4 "CREATE INDEX IF NOT EXISTS node_rlon_idx on nodes (rlon);"
#define OSM_INDEX_5 "CREATE INDEX IF NOT EXISTS node_ilat_idx on nodes (ilat);"
#define OSM_INDEX_6 "CREATE INDEX IF NOT EXISTS node_ilon_idx on nodes (ilon);"

/* Way indexes */
#define OSM_INDEX_7 "CREATE INDEX IF NOT EXISTS way_name_idx on way_names (name);"
/* #define OSM_INDEX_8 "CREATE INDEX IF NOT EXISTS way_norm_name_idx on way_names (norm);" */
#define OSM_INDEX_9 "CREATE UNIQUE INDEX IF NOT EXISTS way_name_nls_id_idx on way_names_nls (wid,lang);"
#define OSM_INDEX_10 "CREATE INDEX IF NOT EXISTS way_name_nls_name_idx on way_names_nls (name);"
/* #define OSM_INDEX_11 "CREATE INDEX IF NOT EXISTS way_norm_nls_name_idx on way_names_nls (norm);" */
#define OSM_INDEX_12 "CREATE INDEX IF NOT EXISTS way_ref_idx on way_ref (ref);"
#define OSM_INDEX_13 "CREATE INDEX IF NOT EXISTS way_n2n_wid_idx on way_n2n (wid);"
#define OSM_INDEX_14 "CREATE INDEX IF NOT EXISTS way_n2n_f_idx on way_n2n (f);"
#define OSM_INDEX_15 "CREATE INDEX IF NOT EXISTS way_n2n_t_idx on way_n2n (t);"

/* Place indexes */
#define OSM_INDEX_16 "CREATE INDEX IF NOT EXISTS place_type on places(type);"

#endif
